/*
 * Decompiled with CFR 0.152.
 */
package com.testingbot.bamboo.action;

import com.atlassian.bamboo.buildqueue.manager.CustomPreBuildQueuedAction;
import com.atlassian.bamboo.configuration.AdministrationConfigurationManager;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.testingbot.bamboo.AbstractTestingBotBuildPlugin;
import com.testingbot.bamboo.config.MappedBuildConfiguration;
import com.testingbot.bamboo.variables.VariableModifier;
import org.jetbrains.annotations.NotNull;

public class EnvironmentConfigurator
extends AbstractTestingBotBuildPlugin
implements CustomPreBuildQueuedAction {
    private AdministrationConfigurationManager administrationConfigurationManager;
    private EnvironmentVariableAccessor environmentVariableAccessor;
    private CustomVariableContext customVariableContext;
    private final String PATTERN_DISALLOWED_TUNNEL_ID_CHARS = "[^\\w\\d-]+";

    public CustomVariableContext getCustomVariableContext() {
        return this.customVariableContext;
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }

    @NotNull
    public BuildContext call() {
        MappedBuildConfiguration config = new MappedBuildConfiguration(this.buildContext.getBuildDefinition().getCustomConfiguration());
        if (config.isEnabled() && config.useGeneratedTunnelIdentifier()) {
            String tunnelIdentifier = this.generateTunnelIdentifier(this.buildContext.getPlanName());
            this.customVariableContext.addCustomData("TUNNEL_IDENTIFIER", tunnelIdentifier);
        }
        if (config.isEnabled()) {
            this.setSeleniumEnvironmentVars(config);
        }
        return this.buildContext;
    }

    private void setSeleniumEnvironmentVars(MappedBuildConfiguration config) {
        VariableModifier variableModifier = this.getVariableModifier(config, this.buildContext.getBuildDefinition(), this.environmentVariableAccessor, this.customVariableContext);
        variableModifier.setAdministrationConfigurationManager(this.administrationConfigurationManager);
        variableModifier.storeVariables();
        variableModifier.populateVariables(this.buildContext.getVariableContext());
    }

    public void setAdministrationConfigurationManager(AdministrationConfigurationManager administrationConfigurationManager) {
        this.administrationConfigurationManager = administrationConfigurationManager;
    }

    public EnvironmentVariableAccessor getEnvironmentVariableAccessor() {
        return this.environmentVariableAccessor;
    }

    public void setEnvironmentVariableAccessor(EnvironmentVariableAccessor environmentVariableAccessor) {
        this.environmentVariableAccessor = environmentVariableAccessor;
    }

    private String generateTunnelIdentifier(String projectName) {
        String sanitizedName = projectName.replaceAll("[^\\w\\d-]+", "_");
        return sanitizedName + "-" + System.currentTimeMillis();
    }
}

