/*
 * Decompiled with CFR 0.152.
 */
package com.testingbot.bamboo.action;

import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.CustomPreBuildAction;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.v2.build.BaseConfigurableBuildPlugin;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.spring.container.ContainerManager;
import com.testingbot.bamboo.config.MappedBuildConfiguration;
import com.testingbot.bamboo.tunnel.TestingBotTunnel;
import com.testingbot.bamboo.util.TestingBotLogInterceptor;
import com.testingbot.testingbotrest.TestingbotREST;
import com.testingbot.tunnel.Api;
import com.testingbot.tunnel.App;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BuildConfigurator
extends BaseConfigurableBuildPlugin
implements CustomPreBuildAction {
    private static final Logger logger = Logger.getLogger(BuildConfigurator.class);
    private CustomVariableContext customVariableContext;
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private PlanManager planManager;
    private static final String DEFAULT_SSH_LOCAL_HOST = "localhost";
    private static final String DEFAULT_SSH_LOCAL_PORT = "8080";

    public CustomVariableContext getCustomVariableContext() {
        return this.customVariableContext;
    }

    @NotNull
    public BuildContext call() {
        BuildLoggerManager buildLoggerManager = (BuildLoggerManager)ContainerManager.getComponent((String)"buildLoggerManager");
        BuildLogger buildLogger = buildLoggerManager.getLogger(this.buildContext.getResultKey());
        try {
            MappedBuildConfiguration config = new MappedBuildConfiguration(this.buildContext.getBuildDefinition().getCustomConfiguration());
            TestingBotLogInterceptor logInterceptor = new TestingBotLogInterceptor(this.buildContext);
            buildLogger.getInterceptorStack().add((LogInterceptor)logInterceptor);
            if (config.isEnabled() && config.isTunnelEnabled()) {
                this.startTunnel(config);
            }
        }
        catch (IOException e) {
            logger.error((Object)"Error running TestingBot BuildConfigurator", (Throwable)e);
        }
        return this.buildContext;
    }

    protected TestingbotREST getRESTClient(MappedBuildConfiguration config) {
        return new TestingbotREST(config.getTempKey(), config.getTempSecret());
    }

    public void startTunnel(MappedBuildConfiguration config) throws IOException {
        App tunnel;
        BuildLoggerManager buildLoggerManager = (BuildLoggerManager)ContainerManager.getComponent((String)"buildLoggerManager");
        final BuildLogger buildLogger = buildLoggerManager.getLogger(this.buildContext.getResultKey());
        PrintStream printLogger = new PrintStream((OutputStream)new NullOutputStream()){

            @Override
            public void println(String x) {
                buildLogger.addBuildLogEntry(x);
            }
        };
        TestingBotTunnel.tunnel = tunnel = new App();
        AdministrationConfiguration adminConfig = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        String apiKey = adminConfig.getSystemProperty("tb.key");
        String apiSecret = adminConfig.getSystemProperty("tb.secret");
        tunnel.setClientKey(apiKey);
        tunnel.setClientSecret(apiSecret);
        try {
            tunnel.init();
            tunnel.setFreeJettyPort();
            tunnel.boot();
            Api api = tunnel.getApi();
            boolean ready = false;
            String tunnelID = Integer.toString(tunnel.getTunnelID());
            while (!ready) {
                try {
                    JSONObject response = api.pollTunnel(tunnelID);
                    ready = response.getString("state").equals("READY");
                }
                catch (Exception ex) {
                    printLogger.println(ex.getMessage());
                    logger.error((Object)ex);
                    break;
                }
                Thread.sleep(3000L);
            }
        }
        catch (Exception ex) {
            printLogger.println(ex.getMessage());
            logger.error((Object)ex);
        }
    }

    private String getResolvedOptions(String tunnelOptions) {
        String options = tunnelOptions;
        if (options != null) {
            return this.customVariableContext.substituteString(options);
        }
        return "";
    }

    protected void populateContextForEdit(Map<String, Object> context, BuildConfiguration buildConfiguration, Plan build) {
        this.populateCommonContext(context);
    }

    public void addDefaultValues(@NotNull BuildConfiguration buildConfiguration) {
        super.addDefaultValues(buildConfiguration);
        if (!buildConfiguration.getKeys("custom.testingbot.").hasNext()) {
            this.addDefaultStringValue(buildConfiguration, "custom.testingbot.ssh.enabled", Boolean.TRUE.toString());
            this.addDefaultStringValue(buildConfiguration, "custom.testingbot.ssh.verbose", Boolean.FALSE.toString());
        }
        this.addDefaultStringValue(buildConfiguration, "custom.testingbot.ssh.local.host", DEFAULT_SSH_LOCAL_HOST);
        this.addDefaultStringValue(buildConfiguration, "custom.testingbot.ssh.local.ports", DEFAULT_SSH_LOCAL_PORT);
    }

    private void addDefaultStringValue(BuildConfiguration buildConfiguration, String configurationKey, String defaultValue) {
        if (StringUtils.isBlank(buildConfiguration.getString(configurationKey))) {
            buildConfiguration.setProperty(configurationKey, (Object)defaultValue);
        }
    }

    private void populateCommonContext(Map<String, Object> context) {
        context.put("hasValidTestingBotConfig", this.hasValidTestingBotConfig());
    }

    public boolean hasValidTestingBotConfig() {
        AdministrationConfiguration adminConfig = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        return StringUtils.isNotBlank(adminConfig.getSystemProperty("tb.key")) && StringUtils.isNotBlank(adminConfig.getSystemProperty("tb.secret"));
    }

    public AdministrationConfigurationAccessor getAdministrationConfigurationAccessor() {
        return this.administrationConfigurationAccessor;
    }

    public void setAdministrationConfigurationAccessor(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }

    public void setCustomVariableContext(CustomVariableContext customVariableContext) {
        this.customVariableContext = customVariableContext;
    }
}

