/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.compression;

import ch.ethz.ssh2.compression.ICompressor;
import java.util.Vector;

public class CompressionFactory {
    static Vector<CompressorEntry> compressors = new Vector();

    public static String[] getDefaultCompressorList() {
        String[] list = new String[compressors.size()];
        for (int i = 0; i < compressors.size(); ++i) {
            CompressorEntry ce = compressors.elementAt(i);
            list[i] = new String(ce.type);
        }
        return list;
    }

    public static void checkCompressorList(String[] compressorCandidates) {
        for (int i = 0; i < compressorCandidates.length; ++i) {
            CompressionFactory.getEntry(compressorCandidates[i]);
        }
    }

    public static ICompressor createCompressor(String type) {
        try {
            CompressorEntry ce = CompressionFactory.getEntry(type);
            if ("".equals(ce.compressorClass)) {
                return null;
            }
            Class<?> cc = Class.forName(ce.compressorClass);
            ICompressor cmp = (ICompressor)cc.newInstance();
            return cmp;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot instantiate " + type);
        }
    }

    private static CompressorEntry getEntry(String type) {
        for (int i = 0; i < compressors.size(); ++i) {
            CompressorEntry ce = compressors.elementAt(i);
            if (!ce.type.equals(type)) continue;
            return ce;
        }
        throw new IllegalArgumentException("Unknown algorithm " + type);
    }

    static {
        compressors.addElement(new CompressorEntry("zlib", "ch.ethz.ssh2.compression.Zlib"));
        compressors.addElement(new CompressorEntry("zlib@openssh.com", "ch.ethz.ssh2.compression.ZlibOpenSSH"));
        compressors.addElement(new CompressorEntry("none", ""));
    }

    static class CompressorEntry {
        String type;
        String compressorClass;

        public CompressorEntry(String type, String compressorClass) {
            this.type = type;
            this.compressorClass = compressorClass;
        }
    }
}

