/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.channel;

import ch.ethz.ssh2.channel.Channel;
import ch.ethz.ssh2.channel.ChannelInputStream;
import ch.ethz.ssh2.channel.ChannelOutputStream;
import ch.ethz.ssh2.channel.StreamForwarder;
import ch.ethz.ssh2.channel.X11ServerData;
import ch.ethz.ssh2.log.Logger;
import ch.ethz.ssh2.util.StringEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class RemoteX11AcceptThread
extends Thread {
    private static final Logger log = Logger.getLogger(RemoteX11AcceptThread.class);
    Channel c;
    String remoteOriginatorAddress;
    int remoteOriginatorPort;
    Socket s;

    public RemoteX11AcceptThread(Channel c, String remoteOriginatorAddress, int remoteOriginatorPort) {
        this.c = c;
        this.remoteOriginatorAddress = remoteOriginatorAddress;
        this.remoteOriginatorPort = remoteOriginatorPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Object digit2;
            this.c.cm.sendOpenConfirmation(this.c);
            ChannelOutputStream remote_os = this.c.getStdinStream();
            ChannelInputStream remote_is = this.c.getStdoutStream();
            byte[] header = new byte[6];
            if (((InputStream)remote_is).read(header) != 6) {
                throw new IOException("Unexpected EOF on X11 startup!");
            }
            if (header[0] != 66 && header[0] != 108) {
                throw new IOException("Unknown endian format in X11 message!");
            }
            int idxMSB = header[0] == 66 ? 0 : 1;
            byte[] auth_buff = new byte[6];
            if (((InputStream)remote_is).read(auth_buff) != 6) {
                throw new IOException("Unexpected EOF on X11 startup!");
            }
            int authProtocolNameLength = (auth_buff[idxMSB] & 0xFF) << 8 | auth_buff[1 - idxMSB] & 0xFF;
            int authProtocolDataLength = (auth_buff[2 + idxMSB] & 0xFF) << 8 | auth_buff[3 - idxMSB] & 0xFF;
            if (authProtocolNameLength > 256 || authProtocolDataLength > 256) {
                throw new IOException("Buggy X11 authorization data");
            }
            int authProtocolNamePadding = (4 - authProtocolNameLength % 4) % 4;
            int authProtocolDataPadding = (4 - authProtocolDataLength % 4) % 4;
            byte[] authProtocolName = new byte[authProtocolNameLength];
            byte[] authProtocolData = new byte[authProtocolDataLength];
            byte[] paddingBuffer = new byte[4];
            if (((InputStream)remote_is).read(authProtocolName) != authProtocolNameLength) {
                throw new IOException("Unexpected EOF on X11 startup! (authProtocolName)");
            }
            if (((InputStream)remote_is).read(paddingBuffer, 0, authProtocolNamePadding) != authProtocolNamePadding) {
                throw new IOException("Unexpected EOF on X11 startup! (authProtocolNamePadding)");
            }
            if (((InputStream)remote_is).read(authProtocolData) != authProtocolDataLength) {
                throw new IOException("Unexpected EOF on X11 startup! (authProtocolData)");
            }
            if (((InputStream)remote_is).read(paddingBuffer, 0, authProtocolDataPadding) != authProtocolDataPadding) {
                throw new IOException("Unexpected EOF on X11 startup! (authProtocolDataPadding)");
            }
            if (!"MIT-MAGIC-COOKIE-1".equals(StringEncoder.GetString(authProtocolName))) {
                throw new IOException("Unknown X11 authorization protocol!");
            }
            if (authProtocolDataLength != 16) {
                throw new IOException("Wrong data length for X11 authorization data!");
            }
            StringBuilder tmp = new StringBuilder(32);
            for (int i = 0; i < authProtocolData.length; ++i) {
                digit2 = Integer.toHexString(authProtocolData[i] & 0xFF);
                tmp.append((String)(((String)digit2).length() == 2 ? digit2 : "0" + (String)digit2));
            }
            String hexEncodedFakeCookie = tmp.toString();
            digit2 = this.c;
            synchronized (digit2) {
                this.c.hexX11FakeCookie = hexEncodedFakeCookie;
            }
            X11ServerData sd = this.c.cm.checkX11Cookie(hexEncodedFakeCookie);
            if (sd == null) {
                throw new IOException("Invalid X11 cookie received.");
            }
            this.s = new Socket(sd.hostname, sd.port);
            OutputStream x11_os = this.s.getOutputStream();
            InputStream x11_is = this.s.getInputStream();
            x11_os.write(header);
            if (sd.x11_magic_cookie == null) {
                byte[] emptyAuthData = new byte[6];
                x11_os.write(emptyAuthData);
            } else {
                if (sd.x11_magic_cookie.length != 16) {
                    throw new IOException("The real X11 cookie has an invalid length!");
                }
                x11_os.write(auth_buff);
                x11_os.write(authProtocolName);
                x11_os.write(paddingBuffer, 0, authProtocolNamePadding);
                x11_os.write(sd.x11_magic_cookie);
                x11_os.write(paddingBuffer, 0, authProtocolDataPadding);
            }
            x11_os.flush();
            StreamForwarder r2l = new StreamForwarder(this.c, null, null, remote_is, x11_os, "RemoteToX11");
            StreamForwarder l2r = new StreamForwarder(this.c, null, null, x11_is, remote_os, "X11ToRemote");
            r2l.setDaemon(true);
            r2l.start();
            l2r.run();
            while (r2l.isAlive()) {
                try {
                    r2l.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.c.cm.closeChannel(this.c, "EOF on both X11 streams reached.", true);
            this.s.close();
        }
        catch (IOException e) {
            log.warning("IOException in X11 proxy code: " + e.getMessage());
            try {
                this.c.cm.closeChannel(this.c, "IOException in X11 proxy code (" + e.getMessage() + ")", true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (this.s != null) {
                    this.s.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

