/*
 * Decompiled with CFR 0.152.
 */
package com.glintech.jira.plugins.termsandconditions.util;

import com.glintech.jira.plugins.termsandconditions.ao.GroupAcceptance;
import com.glintech.jira.plugins.termsandconditions.ao.TermsAndConditions;
import com.glintech.jira.plugins.termsandconditions.enums.Defaults;
import com.glintech.jira.plugins.termsandconditions.exceptions.ServiceException;
import com.glintech.jira.plugins.termsandconditions.rest.model.GroupAcceptanceModel;
import com.glintech.jira.plugins.termsandconditions.rest.model.TermsAndConditionsModel;
import com.glintech.jira.plugins.termsandconditions.service.GroupAcceptanceService;
import com.glintech.jira.plugins.termsandconditions.util.AcceptanceDaoToAcceptanceModelMapper;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermsAndConditionsDaoToModelMapper {
    private static final Logger LOG = LoggerFactory.getLogger(TermsAndConditionsDaoToModelMapper.class);

    public static TermsAndConditionsModel mapTermsAndConditionsDaoToModel(TermsAndConditions tcsDao, GroupAcceptanceService groupAcceptanceService) {
        TermsAndConditionsModel model = new TermsAndConditionsModel();
        model.setId(tcsDao.getID());
        model.setProject(tcsDao.getProject());
        model.setAcceptButtonLabel(tcsDao.getAcceptButtonLabel());
        model.setPageTitle(tcsDao.getPageTitle());
        model.setDeclineButtonLabel(tcsDao.getDeclineButtonLabel());
        model.setGroups((ArrayList)TermsAndConditionsDaoToModelMapper.getGroups(tcsDao, groupAcceptanceService));
        if (tcsDao.getData() != null && tcsDao.getData().length() > 0) {
            model.setData(TermsAndConditionsDaoToModelMapper.sanitizeHtml(tcsDao.getData()));
        }
        return model;
    }

    public static TermsAndConditions mapTermsAndConditionsModelToDao(TermsAndConditionsModel model, TermsAndConditions dao, GroupAcceptanceService groupService) throws ServiceException {
        dao.setProject(model.getProject());
        dao.setData(model.getData());
        dao.setPageTitle(model.getPageTitle());
        dao.setAcceptButtonLabel(model.getAcceptButtonLabel());
        dao.setDeclineButtonLabel(model.getDeclineButtonLabel());
        TermsAndConditionsDaoToModelMapper.setGroups(model, dao, groupService);
        return dao;
    }

    public static TermsAndConditions mapValuesToTermsAndConditionsDao(TermsAndConditions dao, String content, String pageTitle, String acceptButtonLabel, String declineButtonLabel) {
        TermsAndConditionsDaoToModelMapper.saveAcceptButtonLabel(acceptButtonLabel, dao);
        TermsAndConditionsDaoToModelMapper.saveDeclineButtonLabel(declineButtonLabel, dao);
        TermsAndConditionsDaoToModelMapper.savePageTitle(pageTitle, dao);
        TermsAndConditionsDaoToModelMapper.saveTermsAndConditions(content, dao);
        return dao;
    }

    private static void saveAcceptButtonLabel(String label, TermsAndConditions tcs) {
        String acceptLabel = !Strings.isNullOrEmpty((String)label) ? label : Defaults.ACCEPT.getText();
        tcs.setAcceptButtonLabel(acceptLabel);
        tcs.save();
    }

    private static void saveDeclineButtonLabel(String label, TermsAndConditions tcs) {
        String declineLabel = !Strings.isNullOrEmpty((String)label) ? label : Defaults.DECLINE.getText();
        tcs.setDeclineButtonLabel(declineLabel);
        tcs.save();
    }

    private static void savePageTitle(String pageTitle, TermsAndConditions tcs) {
        String title = !Strings.isNullOrEmpty((String)pageTitle) ? pageTitle : Defaults.TITLE.getText();
        tcs.setPageTitle(title);
        tcs.save();
    }

    private static void saveTermsAndConditions(String tcContent, TermsAndConditions termsAndConditions) {
        String content = !Strings.isNullOrEmpty((String)tcContent) ? tcContent : Defaults.CONTENT.getText();
        termsAndConditions.setData(StringEscapeUtils.escapeHtml4(content));
        termsAndConditions.save();
    }

    private static List<GroupAcceptanceModel> getGroups(TermsAndConditions tcsDao, GroupAcceptanceService groupAcceptanceService) {
        ArrayList<GroupAcceptanceModel> modelGroups = new ArrayList<GroupAcceptanceModel>();
        try {
            List<GroupAcceptance> groupsByTCsId = groupAcceptanceService.getByConfigId(tcsDao.getID());
            GroupAcceptance[] groups = new GroupAcceptance[groupsByTCsId.size()];
            groupsByTCsId.toArray(groups);
            if (groups != null) {
                TermsAndConditionsDaoToModelMapper.quickSort(groups, 0, groups.length - 1);
                for (GroupAcceptance group : groups) {
                    modelGroups.add(AcceptanceDaoToAcceptanceModelMapper.mapStatusDaoToGroupModel(group));
                }
            }
        }
        catch (ServiceException se) {
            LOG.error("No groups are associated to the current TCs config. We fail safe and return and empty list.");
        }
        return modelGroups;
    }

    private static void setGroups(TermsAndConditionsModel model, TermsAndConditions dao, GroupAcceptanceService groupService) throws ServiceException {
        GroupAcceptance[] persistedAcceptances = dao.getGroupAcceptances();
        ArrayList newGroups = model.getGroups() != null ? model.getGroups() : new ArrayList();
        ArrayList<GroupAcceptanceModel> groupsToRemove = new ArrayList<GroupAcceptanceModel>();
        for (GroupAcceptance groupAcceptance : persistedAcceptances) {
            boolean found = false;
            for (GroupAcceptanceModel group : model.getGroups()) {
                if (!groupAcceptance.getName().equals(group.getName())) continue;
                found = true;
                groupsToRemove.add(group);
            }
            newGroups.removeAll(groupsToRemove);
            if (found) continue;
            groupService.delete(groupAcceptance.getID());
        }
        if (newGroups.size() > 0) {
            for (GroupAcceptanceModel group : newGroups) {
                group.setAccepted(false);
                group.setAccessed(false);
                GroupAcceptance updatedGroupAcceptance = (GroupAcceptance)groupService.save(group);
                updatedGroupAcceptance.setTermsAndConditions(dao);
                updatedGroupAcceptance.save();
            }
        }
        model.setGroups((ArrayList)groupService.getList());
    }

    private static String sanitizeHtml(String html) {
        String sanitizedHtml = html;
        if (!TermsAndConditionsDaoToModelMapper.isHtml(html)) {
            sanitizedHtml = TermsAndConditionsDaoToModelMapper.addLineBreaks(html);
        }
        Safelist safelist = Safelist.relaxed().addTags("style").addAttributes("a", "target", "rel").addAttributes(":all", "class", "style").addProtocols("a", "href", "http", "https", "mailto").addEnforcedAttribute("a", "rel", "noopener noreferrer nofollow").addEnforcedAttribute("a", "target", "_blank");
        sanitizedHtml = Jsoup.clean(sanitizedHtml, safelist);
        return sanitizedHtml;
    }

    private static String addLineBreaks(String html) {
        String parsedHtml = html.replaceAll("\n<br \\/><", "\n<");
        parsedHtml = parsedHtml.replaceAll("\n<br \\/>", "\n");
        parsedHtml = parsedHtml.replaceAll("\n", "\n<br />");
        parsedHtml = parsedHtml.replaceAll("\n<br \\/><", "\n<");
        return parsedHtml;
    }

    private static boolean isHtml(String html) {
        Pattern pattern = Pattern.compile("/<\\/?[a-z][\\s\\S]*>/i", 2);
        Matcher matcher = pattern.matcher(html);
        boolean matchFound = matcher.find();
        return matchFound;
    }

    private static void quickSort(GroupAcceptance[] array, int begin, int end) {
        if (end <= begin) {
            return;
        }
        int pivot = TermsAndConditionsDaoToModelMapper.partition(array, begin, end);
        TermsAndConditionsDaoToModelMapper.quickSort(array, begin, pivot - 1);
        TermsAndConditionsDaoToModelMapper.quickSort(array, pivot + 1, end);
    }

    private static int partition(GroupAcceptance[] array, int begin, int end) {
        int pivot = end;
        int counter = begin;
        for (int i = begin; i < end; ++i) {
            if (array[i].getID() >= array[pivot].getID()) continue;
            GroupAcceptance temp = array[counter];
            array[counter] = array[i];
            array[i] = temp;
            ++counter;
        }
        GroupAcceptance temp = array[pivot];
        array[pivot] = array[counter];
        array[counter] = temp;
        return counter;
    }
}

