/*
 * Decompiled with CFR 0.152.
 */
package com.glintech.jira.plugins.termsandconditions.util;

import com.glintech.jira.plugins.termsandconditions.ao.Acceptance;
import com.glintech.jira.plugins.termsandconditions.ao.GroupAcceptance;
import com.glintech.jira.plugins.termsandconditions.enums.Defaults;
import com.glintech.jira.plugins.termsandconditions.exceptions.ServiceException;
import com.glintech.jira.plugins.termsandconditions.rest.model.GroupAcceptanceModel;
import com.glintech.jira.plugins.termsandconditions.rest.model.UserAcceptanceModel;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class AcceptanceDaoToAcceptanceModelMapper {
    public static UserAcceptanceModel mapStatusDaoToUserModel(Acceptance acceptance) {
        UserAcceptanceModel model = new UserAcceptanceModel();
        model.setId(acceptance.getID() > 0 ? acceptance.getID() : -1);
        model.setUsername(acceptance.getUsername());
        model.setAccepted(acceptance.getAccepted());
        model.setDateandTime(acceptance.getDateandTime());
        return model;
    }

    public static Acceptance mapUserAcceptanceModelToDao(UserAcceptanceModel model, Acceptance acceptance) {
        String datetime = model.getDateandTime();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("EEE MMM dd hh:mm:ss zzz yyy").withZone(ZoneId.systemDefault());
        Instant instant = null;
        try {
            instant = Instant.parse(model.getDateandTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (instant != null) {
            datetime = formatter.format(instant).toString();
        }
        acceptance.setUsername(model.getUsername());
        acceptance.setAccepted(model.getAccepted());
        acceptance.setAccessed(model.getAccessed());
        acceptance.setDateandTime(datetime);
        String project = StringUtils.isEmpty(model.getProject()) ? Defaults.PROJECT.getText() : model.getProject();
        acceptance.setProject(project);
        return acceptance;
    }

    public static GroupAcceptanceModel mapStatusDaoToGroupModel(GroupAcceptance acceptance) {
        GroupAcceptanceModel model = new GroupAcceptanceModel();
        model.setId(acceptance.getID());
        model.setName(acceptance.getName());
        model.setDateandTime(acceptance.getDateandTime());
        model.setAccepted(acceptance.isAccepted());
        model.setAccessed(acceptance.isAccessed());
        if (!Objects.isNull(acceptance.getAcceptance())) {
            model.setAcceptanceModel(AcceptanceDaoToAcceptanceModelMapper.mapStatusDaoToUserModel(acceptance.getAcceptance()));
        }
        return model;
    }

    public static GroupAcceptance mapGroupAcceptanceModelToDao(GroupAcceptanceModel model, GroupAcceptance acceptance) throws ServiceException {
        acceptance.setName(model.getName());
        acceptance.setAccepted(model.getAccepted());
        acceptance.setAccessed(model.getAccessed());
        acceptance.setDateandTime(Calendar.getInstance().getTime().toString());
        return acceptance;
    }

    public static List<String> mapGroupAcceptanceModelsToStringList(List<GroupAcceptanceModel> models) {
        ArrayList<String> groupNames = new ArrayList<String>();
        for (GroupAcceptanceModel model : models) {
            groupNames.add(model.getName());
        }
        return groupNames;
    }
}

