/*
 * Decompiled with CFR 0.152.
 */
package com.glintech.jira.plugins.termsandconditions.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.tx.Transactional;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.sal.api.message.I18nResolver;
import com.glintech.jira.plugins.termsandconditions.ao.Acceptance;
import com.glintech.jira.plugins.termsandconditions.ao.GroupAcceptance;
import com.glintech.jira.plugins.termsandconditions.enums.Defaults;
import com.glintech.jira.plugins.termsandconditions.exceptions.ServiceException;
import com.glintech.jira.plugins.termsandconditions.rest.model.AuditModel;
import com.glintech.jira.plugins.termsandconditions.rest.model.GroupAcceptanceModel;
import com.glintech.jira.plugins.termsandconditions.rest.model.TermsAndConditionsModel;
import com.glintech.jira.plugins.termsandconditions.rest.model.UserAcceptanceModel;
import com.glintech.jira.plugins.termsandconditions.service.AuditService;
import com.glintech.jira.plugins.termsandconditions.service.GroupAcceptanceService;
import com.glintech.jira.plugins.termsandconditions.service.TermsAndConditionsService;
import com.glintech.jira.plugins.termsandconditions.service.UserAcceptanceService;
import com.glintech.jira.plugins.termsandconditions.util.AcceptanceDaoToAcceptanceModelMapper;
import com.glintech.jira.plugins.termsandconditions.util.Util;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import net.java.ao.DBParam;
import net.java.ao.EntityStreamCallback;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Transactional
public class UserAcceptanceServiceImpl
implements UserAcceptanceService {
    private final ActiveObjects activeObjects;
    private final I18nResolver i18n;
    private final UserUtil userUtil;
    private final GroupAcceptanceService groupAcceptanceService;
    private final TermsAndConditionsService termsAndConditionsService;
    private final AuditService auditService;
    private static final Logger LOG = LoggerFactory.getLogger(UserAcceptanceServiceImpl.class);

    public UserAcceptanceServiceImpl(ActiveObjects activeObjects, I18nResolver i18n, UserUtil userUtil, GroupAcceptanceService groupAcceptanceService, TermsAndConditionsService termsAndConditionsService, AuditService auditService) {
        this.activeObjects = Util.checkNotNull(activeObjects);
        this.i18n = Util.checkNotNull(i18n);
        this.userUtil = Util.checkNotNull(userUtil);
        this.groupAcceptanceService = Util.checkNotNull(groupAcceptanceService);
        this.termsAndConditionsService = Util.checkNotNull(termsAndConditionsService);
        this.auditService = Util.checkNotNull(auditService);
    }

    @Override
    public List<UserAcceptanceModel> getList() {
        ArrayList<UserAcceptanceModel> models = new ArrayList<UserAcceptanceModel>();
        for (Acceptance acceptance : (Acceptance[])this.activeObjects.find(Acceptance.class)) {
            UserAcceptanceModel model = AcceptanceDaoToAcceptanceModelMapper.mapStatusDaoToUserModel(acceptance);
            models.add(model);
        }
        return models;
    }

    @Override
    public boolean isAccepted(String username) throws ServiceException {
        Acceptance user = this.getByUsername(username);
        if (!Objects.isNull(user)) {
            return user.getAccepted();
        }
        throw new ServiceException("Could not find user with username: " + username);
    }

    @Override
    public Acceptance getByUsername(String username) {
        Acceptance user = null;
        List<Acceptance> users = this.getDaosByUsername(username);
        if (users.size() > 0) {
            user = users.get(0);
        }
        return user;
    }

    private List<Acceptance> getDaosByUsername(String user) {
        ArrayList<Acceptance> userAcceptances = new ArrayList<Acceptance>();
        Query query = Query.select((String)"ID, USERNAME, ACCEPTED, ACCESSED, DATEAND_TIME, PROJECT");
        this.activeObjects.stream(Acceptance.class, query, acceptance -> {
            if (acceptance.getUsername().equalsIgnoreCase(user)) {
                userAcceptances.add((Acceptance)acceptance);
            }
        });
        return userAcceptances;
    }

    @Override
    public Acceptance save(UserAcceptanceModel model) throws ServiceException {
        Acceptance dao = (Acceptance)this.activeObjects.create(Acceptance.class, new DBParam[0]);
        dao = AcceptanceDaoToAcceptanceModelMapper.mapUserAcceptanceModelToDao(model, dao);
        dao.save();
        return dao;
    }

    @Override
    public Acceptance update(UserAcceptanceModel model) throws ServiceException {
        Acceptance dao = this.getById(model.getId());
        if (!Objects.isNull(dao)) {
            dao = AcceptanceDaoToAcceptanceModelMapper.mapUserAcceptanceModelToDao(model, dao);
            dao.save();
            return dao;
        }
        throw new ServiceException("Could not find user with username: " + model.getUsername());
    }

    @Override
    public void delete(int id) throws ServiceException {
        Acceptance dao = this.getById(id);
        this.activeObjects.delete(new RawEntity[]{dao});
    }

    @Override
    public void reset(int id) {
        if (id > 0) {
            for (Acceptance acceptance : (Acceptance[])this.activeObjects.find(Acceptance.class)) {
                if (acceptance.getID() != id) continue;
                try {
                    UserAcceptanceModel model = this.getModelById(id);
                    model.setAccepted(false);
                    this.update(model);
                }
                catch (ServiceException e) {
                    LOG.error(e.getMessage());
                }
            }
        }
    }

    @Override
    public void resetAll() throws ServiceException {
        for (Acceptance acceptance : (Acceptance[])this.activeObjects.find(Acceptance.class)) {
            this.reset(acceptance.getID());
        }
    }

    @Override
    public boolean isUserInAcceptedGroup(String username) throws ServiceException {
        if (!username.isEmpty()) {
            List<String> acceptedGroups = this.groupAcceptanceService.getAllAcceptedGroupNames();
            SortedSet userGroups = this.userUtil.getGroupsForUser(username);
            for (Group group : userGroups) {
                if (!acceptedGroups.contains(group.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public UserAcceptanceModel saveOrUpdate(UserAcceptanceModel model) throws ServiceException {
        Acceptance acceptance = this.getByUsername(model.getUsername());
        if (!Objects.isNull(acceptance)) {
            acceptance = this.update(model);
            this.associateUserWithGroup(model, acceptance);
            return AcceptanceDaoToAcceptanceModelMapper.mapStatusDaoToUserModel(acceptance);
        }
        Acceptance result = this.save(model);
        this.associateUserWithGroup(model, result);
        return AcceptanceDaoToAcceptanceModelMapper.mapStatusDaoToUserModel(result);
    }

    @Override
    public List<Acceptance> getAll() {
        ArrayList<Acceptance> acceptedUsers = new ArrayList<Acceptance>();
        this.activeObjects.stream(Acceptance.class, acceptance -> acceptedUsers.add((Acceptance)acceptance));
        return acceptedUsers;
    }

    @Override
    public List<UserAcceptanceModel> get(int limit, int offset) {
        final ArrayList<UserAcceptanceModel> acceptedUsers = new ArrayList<UserAcceptanceModel>();
        Query query = Query.select((String)"ID, USERNAME, ACCEPTED, DATEAND_TIME");
        this.activeObjects.stream(Acceptance.class, query.limit(limit).offset(offset), (EntityStreamCallback)new EntityStreamCallback<Acceptance, Integer>(){

            public void onRowRead(Acceptance acceptance) {
                acceptedUsers.add(AcceptanceDaoToAcceptanceModelMapper.mapStatusDaoToUserModel(acceptance));
            }
        });
        return acceptedUsers;
    }

    @Override
    public List<UserAcceptanceModel> getAllAcceptedUserModels() throws ServiceException {
        ArrayList<UserAcceptanceModel> acceptedUsers = new ArrayList<UserAcceptanceModel>();
        for (Acceptance acceptance : this.getAll()) {
            if (!acceptance.getAccepted().booleanValue()) continue;
            acceptedUsers.add(AcceptanceDaoToAcceptanceModelMapper.mapStatusDaoToUserModel(acceptance));
        }
        return acceptedUsers;
    }

    @Override
    public UserAcceptanceModel getModelById(int id) throws ServiceException {
        UserAcceptanceModel model = null;
        Acceptance dao = (Acceptance)this.activeObjects.get(Acceptance.class, (Object)id);
        if (dao == null) {
            LOG.error(this.i18n.getText("termsandconditions.status.get.fail"));
            throw new ServiceException(this.i18n.getText("termsandconditions.status.get.fail"));
        }
        model = AcceptanceDaoToAcceptanceModelMapper.mapStatusDaoToUserModel(dao);
        LOG.debug("Status was found with ID: " + id);
        return model;
    }

    @Override
    public Acceptance getById(int id) throws ServiceException {
        Acceptance dao = (Acceptance)this.activeObjects.get(Acceptance.class, (Object)id);
        if (dao == null) {
            LOG.error(this.i18n.getText("termsandconditions.status.get.fail"));
            throw new ServiceException(this.i18n.getText("termsandconditions.status.get.fail"));
        }
        return dao;
    }

    private GroupAcceptanceModel findConfigureGroupForUser(UserAcceptanceModel user) throws ServiceException {
        GroupAcceptanceModel foundGroup = null;
        SortedSet userGroups = this.userUtil.getGroupsForUser(user.getUsername());
        TermsAndConditionsModel tcsModel = this.termsAndConditionsService.getByProject(Defaults.PROJECT.getText());
        if (!Objects.isNull(tcsModel) && !Objects.isNull(tcsModel.getGroups())) {
            List<String> configuredGroups = AcceptanceDaoToAcceptanceModelMapper.mapGroupAcceptanceModelsToStringList(tcsModel.getGroups());
            for (Group userGroup : userGroups) {
                if (!configuredGroups.contains(userGroup.getName())) continue;
                foundGroup = tcsModel.getGroups().stream().filter(group -> userGroup.getName().equals(group.getName())).findAny().orElse(null);
                return foundGroup;
            }
        }
        return foundGroup;
    }

    private void associateUserWithGroup(UserAcceptanceModel model, Acceptance acceptance) throws ServiceException {
        GroupAcceptanceModel gam = this.findConfigureGroupForUser(model);
        if (gam != null && !gam.getName().isEmpty() && (gam.getAccepted().booleanValue() || model.getAccepted().booleanValue())) {
            gam.setAccepted(true);
            gam.setAccessed(true);
            String datetime = Calendar.getInstance().getTime().toString();
            GroupAcceptance ga = (GroupAcceptance)this.groupAcceptanceService.update(gam);
            ga.setAcceptance(acceptance);
            ga.setDateandTime(datetime);
            ga.save();
            AuditModel audit = new AuditModel();
            audit.setGroup(ga.getName());
            audit.setUsername(model.getUsername());
            audit.setDatetime(datetime);
            audit.setAction(Defaults.ACCEPT.getText());
            this.auditService.save(audit);
        }
    }
}

