/*
 * Decompiled with CFR 0.152.
 */
package com.glintech.jira.plugins.termsandconditions.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.tx.Transactional;
import com.glintech.jira.plugins.termsandconditions.ao.TermsAndConditions;
import com.glintech.jira.plugins.termsandconditions.enums.Defaults;
import com.glintech.jira.plugins.termsandconditions.exceptions.ServiceException;
import com.glintech.jira.plugins.termsandconditions.rest.model.TermsAndConditionsModel;
import com.glintech.jira.plugins.termsandconditions.service.GroupAcceptanceService;
import com.glintech.jira.plugins.termsandconditions.service.TermsAndConditionsService;
import com.glintech.jira.plugins.termsandconditions.util.TermsAndConditionsDaoToModelMapper;
import com.glintech.jira.plugins.termsandconditions.util.Util;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.EntityStreamCallback;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.StringUtils;

@Transactional
public class TermsAndConditionsServiceImpl
implements TermsAndConditionsService {
    private final ActiveObjects activeObjects;
    private final GroupAcceptanceService groupAcceptanceService;

    public TermsAndConditionsServiceImpl(ActiveObjects activeObjects, GroupAcceptanceService groupAcceptanceService) {
        this.activeObjects = Util.checkNotNull(activeObjects);
        this.groupAcceptanceService = Util.checkNotNull(groupAcceptanceService);
    }

    @Override
    public List<TermsAndConditions> getAll() {
        final ArrayList<TermsAndConditions> tcs = new ArrayList<TermsAndConditions>();
        this.activeObjects.stream(TermsAndConditions.class, (EntityStreamCallback)new EntityStreamCallback<TermsAndConditions, Integer>(){

            public void onRowRead(TermsAndConditions tc) {
                tcs.add(tc);
            }
        });
        return tcs;
    }

    @Override
    public List<TermsAndConditionsModel> getList() throws ServiceException {
        ArrayList<TermsAndConditionsModel> models = new ArrayList<TermsAndConditionsModel>();
        for (TermsAndConditions termsAndConditions : this.getAll()) {
            TermsAndConditionsModel model = this.getDefaultTermsAndConditions(termsAndConditions);
            models.add(model);
        }
        return models;
    }

    public TermsAndConditionsModel getDefaultTermsAndConditions(TermsAndConditions termsAndConditions) {
        TermsAndConditionsModel tcsModel = TermsAndConditionsDaoToModelMapper.mapTermsAndConditionsDaoToModel(termsAndConditions, this.groupAcceptanceService);
        if (StringUtils.isEmpty(termsAndConditions.getPageTitle())) {
            tcsModel.setPageTitle(Defaults.TITLE.getText());
        }
        if (StringUtils.isEmpty(termsAndConditions.getAcceptButtonLabel())) {
            tcsModel.setAcceptButtonLabel(Defaults.ACCEPT.getText());
        }
        if (StringUtils.isEmpty(termsAndConditions.getDeclineButtonLabel())) {
            tcsModel.setDeclineButtonLabel(Defaults.DECLINE.getText());
        }
        if (StringUtils.isEmpty(termsAndConditions.getData())) {
            tcsModel.setData(Defaults.CONTENT.getText());
        }
        if (StringUtils.isEmpty(termsAndConditions.getProject())) {
            tcsModel.setProject(Defaults.PROJECT.getText());
        }
        return tcsModel;
    }

    @Override
    public TermsAndConditionsModel get(int id) throws ServiceException {
        TermsAndConditions dao = (TermsAndConditions)this.activeObjects.get(TermsAndConditions.class, (Object)id);
        TermsAndConditionsModel model = TermsAndConditionsDaoToModelMapper.mapTermsAndConditionsDaoToModel(dao, this.groupAcceptanceService);
        return model;
    }

    @Override
    public TermsAndConditionsModel getByProject(String project) throws ServiceException {
        ArrayList<TermsAndConditions> daos = this.getDaosByProject(project);
        TermsAndConditionsModel model = null;
        if (daos.size() > 0) {
            for (TermsAndConditions dao : daos) {
                model = TermsAndConditionsDaoToModelMapper.mapTermsAndConditionsDaoToModel(dao, this.groupAcceptanceService);
            }
        }
        return model;
    }

    private ArrayList<TermsAndConditions> getDaosByProject(String project) {
        ArrayList tcs = Lists.newArrayList((Object[])((TermsAndConditions[])this.activeObjects.find(TermsAndConditions.class)));
        ArrayList<TermsAndConditions> selectedTcs = new ArrayList<TermsAndConditions>();
        for (TermsAndConditions dao : tcs) {
            if (dao.getProject() == null || !dao.getProject().equals(project)) continue;
            selectedTcs.add(dao);
        }
        return selectedTcs;
    }

    @Override
    public TermsAndConditionsModel save(TermsAndConditionsModel model) throws ServiceException {
        TermsAndConditions dao = (TermsAndConditions)this.activeObjects.create(TermsAndConditions.class, new DBParam[0]);
        dao = TermsAndConditionsDaoToModelMapper.mapTermsAndConditionsModelToDao(model, dao, this.groupAcceptanceService);
        dao.save();
        model = TermsAndConditionsDaoToModelMapper.mapTermsAndConditionsDaoToModel(dao, this.groupAcceptanceService);
        return model;
    }

    @Override
    public TermsAndConditionsModel update(TermsAndConditionsModel model) throws ServiceException {
        TermsAndConditions dao = (TermsAndConditions)this.activeObjects.get(TermsAndConditions.class, (Object)model.getId());
        if (dao != null) {
            dao = TermsAndConditionsDaoToModelMapper.mapTermsAndConditionsModelToDao(model, dao, this.groupAcceptanceService);
            dao.save();
            model = TermsAndConditionsDaoToModelMapper.mapTermsAndConditionsDaoToModel(dao, this.groupAcceptanceService);
        }
        return model;
    }

    @Override
    public void delete(int id) {
        TermsAndConditions dao = (TermsAndConditions)this.activeObjects.get(TermsAndConditions.class, (Object)id);
        if (dao != null) {
            this.activeObjects.delete(new RawEntity[]{dao});
        }
    }
}

