/*
 * Decompiled with CFR 0.152.
 */
package com.glintech.jira.plugins.termsandconditions.service;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.glintech.jira.plugins.termsandconditions.rest.model.FilterModel;
import com.glintech.jira.plugins.termsandconditions.rest.model.UserAcceptanceModel;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsdFilterService {
    ProjectRoleManager projectRoleManager;
    ProjectManager projectManager;
    UserManager userManager;
    private static final Logger LOG = LoggerFactory.getLogger(JsdFilterService.class);

    public JsdFilterService(ProjectRoleManager projectRoleManager, ProjectManager projectManager, UserManager userManager) {
        this.projectRoleManager = projectRoleManager;
        this.projectManager = projectManager;
        this.userManager = userManager;
    }

    public Boolean isValid(UserAcceptanceModel acceptance, FilterModel model) {
        Boolean isValid = false;
        ApplicationUser user = this.userManager.getUserByName(acceptance.getUsername());
        for (Project project : this.projectManager.getProjects()) {
            Collection roles = this.projectRoleManager.getProjectRoles(user, project);
            ProjectRole jsd = this.projectRoleManager.getProjectRole("Service Desk Customers");
            if (jsd == null || !roles.contains(jsd)) continue;
            isValid = true;
        }
        return isValid;
    }
}

