/*
 * Decompiled with CFR 0.152.
 */
package com.glintech.jira.plugins.termsandconditions.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.tx.Transactional;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.sal.api.message.I18nResolver;
import com.glintech.jira.plugins.termsandconditions.ao.GroupAcceptance;
import com.glintech.jira.plugins.termsandconditions.enums.Defaults;
import com.glintech.jira.plugins.termsandconditions.exceptions.ServiceException;
import com.glintech.jira.plugins.termsandconditions.rest.model.AuditModel;
import com.glintech.jira.plugins.termsandconditions.rest.model.GroupAcceptanceModel;
import com.glintech.jira.plugins.termsandconditions.service.AuditService;
import com.glintech.jira.plugins.termsandconditions.service.GroupAcceptanceService;
import com.glintech.jira.plugins.termsandconditions.service.UserAcceptanceService;
import com.glintech.jira.plugins.termsandconditions.util.AcceptanceDaoToAcceptanceModelMapper;
import com.glintech.jira.plugins.termsandconditions.util.Util;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Transactional
public class GroupAcceptanceServiceImpl
implements GroupAcceptanceService {
    private final ActiveObjects activeObjects;
    private final I18nResolver i18n;
    private final AuditService auditService;
    private static final Logger LOG = LoggerFactory.getLogger(UserAcceptanceService.class);

    public GroupAcceptanceServiceImpl(ActiveObjects activeObjects, I18nResolver i18n, AuditService auditService) {
        this.activeObjects = Util.checkNotNull(activeObjects);
        this.i18n = Util.checkNotNull(i18n);
        this.auditService = Util.checkNotNull(auditService);
    }

    @Override
    public List<GroupAcceptanceModel> getAllAcceptedGroupModels() throws ServiceException {
        return this.getAcceptances(0, 0, true);
    }

    @Override
    public boolean isAccepted(String groupName) throws ServiceException {
        if (groupName != null && !groupName.isEmpty()) {
            for (GroupAcceptance acceptance : (GroupAcceptance[])this.activeObjects.find(GroupAcceptance.class)) {
                if (!acceptance.getName().equals(groupName)) continue;
                return acceptance.isAccepted();
            }
        }
        return false;
    }

    @Override
    public void reset(int id) throws ServiceException {
        if (id > 0) {
            for (GroupAcceptance acceptance : (GroupAcceptance[])this.activeObjects.find(GroupAcceptance.class)) {
                if (acceptance.getID() != id) continue;
                acceptance.setAccepted(false);
                acceptance.save();
                this.createAndSaveAudit(acceptance);
            }
        }
    }

    @Override
    public void resetAll() throws ServiceException {
        for (GroupAcceptance acceptance : (GroupAcceptance[])this.activeObjects.find(GroupAcceptance.class)) {
            this.reset(acceptance.getID());
        }
    }

    @Override
    public List<GroupAcceptance> getAll() {
        ArrayList<GroupAcceptance> acceptedGroups = new ArrayList<GroupAcceptance>();
        this.activeObjects.stream(GroupAcceptance.class, acceptedGroups::add);
        return acceptedGroups;
    }

    @Override
    public List<GroupAcceptanceModel> get(int limit, int offset) {
        return this.getAcceptances(limit, offset, true);
    }

    public List<GroupAcceptanceModel> getAcceptances(int limit, int offset, boolean all) {
        ArrayList<GroupAcceptanceModel> acceptedGroups = new ArrayList<GroupAcceptanceModel>();
        Query query = Query.select((String)"ID, NAME, ACCEPTED, ACCEPTANCE_ID, DATEAND_TIME, TERMS_AND_CONDITIONS_ID");
        if (!all) {
            query = query.limit(limit).offset(offset);
        }
        this.activeObjects.stream(GroupAcceptance.class, query, acceptance -> {
            if (acceptance.isAccepted()) {
                acceptedGroups.add(AcceptanceDaoToAcceptanceModelMapper.mapStatusDaoToGroupModel(acceptance));
            }
        });
        return acceptedGroups;
    }

    @Override
    public GroupAcceptanceModel getModelById(int id) throws ServiceException {
        GroupAcceptance dao = (GroupAcceptance)this.activeObjects.get(GroupAcceptance.class, (Object)id);
        if (dao == null) {
            LOG.error(this.i18n.getText("termsandconditions.status.get.fail"));
            throw new ServiceException(this.i18n.getText("termsandconditions.status.get.fail"));
        }
        GroupAcceptanceModel model = AcceptanceDaoToAcceptanceModelMapper.mapStatusDaoToGroupModel(dao);
        LOG.debug("Status was found with ID: " + id);
        return model;
    }

    @Override
    public GroupAcceptance getById(int id) throws ServiceException {
        GroupAcceptance dao = (GroupAcceptance)this.activeObjects.get(GroupAcceptance.class, (Object)id);
        if (dao == null) {
            LOG.error(this.i18n.getText("termsandconditions.status.get.fail"));
            throw new ServiceException(this.i18n.getText("termsandconditions.status.get.fail"));
        }
        return dao;
    }

    @Override
    public List<GroupAcceptanceModel> getList() throws ServiceException {
        ArrayList<GroupAcceptanceModel> models = new ArrayList<GroupAcceptanceModel>();
        for (GroupAcceptance acceptance : (GroupAcceptance[])this.activeObjects.find(GroupAcceptance.class)) {
            GroupAcceptanceModel model = AcceptanceDaoToAcceptanceModelMapper.mapStatusDaoToGroupModel(acceptance);
            models.add(model);
        }
        return models;
    }

    @Override
    public List<GroupAcceptance> getByConfigId(int tcsId) throws ServiceException {
        ArrayList<GroupAcceptance> groupsByTCsId = new ArrayList<GroupAcceptance>();
        Query query = Query.select((String)"ID, NAME, ACCEPTED, ACCEPTANCE_ID, DATEAND_TIME, TERMS_AND_CONDITIONS_ID");
        this.activeObjects.stream(GroupAcceptance.class, query, acceptance -> {
            if (acceptance.getTermsAndConditions().getID() == tcsId) {
                groupsByTCsId.add((GroupAcceptance)acceptance);
            }
        });
        return groupsByTCsId;
    }

    @Override
    public List<String> getAllAcceptedGroupNames() throws ServiceException {
        ArrayList<String> groupNames = new ArrayList<String>();
        for (GroupAcceptanceModel model : this.getAllAcceptedGroupModels()) {
            groupNames.add(model.getName());
        }
        return groupNames;
    }

    @Override
    public GroupAcceptance save(GroupAcceptanceModel model) throws ServiceException {
        GroupAcceptance dao = (GroupAcceptance)this.activeObjects.create(GroupAcceptance.class, new DBParam[0]);
        AcceptanceDaoToAcceptanceModelMapper.mapGroupAcceptanceModelToDao(model, dao);
        dao.save();
        return dao;
    }

    @Override
    public GroupAcceptance update(GroupAcceptanceModel model) throws ServiceException {
        GroupAcceptance dao = (GroupAcceptance)this.activeObjects.get(GroupAcceptance.class, (Object)model.getId());
        AcceptanceDaoToAcceptanceModelMapper.mapGroupAcceptanceModelToDao(model, dao);
        dao.save();
        return dao;
    }

    @Override
    public void delete(int id) throws ServiceException {
        GroupAcceptance dao = this.getById(id);
        this.activeObjects.delete(new RawEntity[]{dao});
    }

    private void createAndSaveAudit(GroupAcceptance gam) throws ServiceException {
        AuditModel auditModel = new AuditModel();
        auditModel.setAction(Defaults.RESET.getText());
        auditModel.setDatetime(Calendar.getInstance().getTime().toString());
        auditModel.setGroup(gam.getName());
        auditModel.setUsername(ComponentAccessor.getJiraAuthenticationContext().getLoggedInUser().getUsername());
        this.auditService.save(auditModel);
    }
}

