/*
 * Decompiled with CFR 0.152.
 */
package com.glintech.jira.plugins.termsandconditions.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.tx.Transactional;
import com.atlassian.sal.api.message.I18nResolver;
import com.glintech.jira.plugins.termsandconditions.ao.Audit;
import com.glintech.jira.plugins.termsandconditions.exceptions.ServiceException;
import com.glintech.jira.plugins.termsandconditions.rest.model.AuditModel;
import com.glintech.jira.plugins.termsandconditions.service.AuditService;
import com.glintech.jira.plugins.termsandconditions.util.AuditDaoToAuditModelMapper;
import java.util.ArrayList;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.EntityStreamCallback;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Transactional
public class AuditServiceImpl
implements AuditService {
    private final I18nResolver i18n;
    private final ActiveObjects activeObjects;
    private final Logger LOG = LoggerFactory.getLogger(AuditServiceImpl.class);

    public AuditServiceImpl(ActiveObjects activeObjects, I18nResolver i18n) {
        this.activeObjects = activeObjects;
        this.i18n = i18n;
    }

    @Override
    public List<Audit> getAll() {
        final ArrayList<Audit> audits = new ArrayList<Audit>();
        this.activeObjects.stream(Audit.class, (EntityStreamCallback)new EntityStreamCallback<Audit, Integer>(){

            public void onRowRead(Audit audit) {
                audits.add(audit);
            }
        });
        return audits;
    }

    @Override
    public List<AuditModel> getList() throws ServiceException {
        ArrayList<AuditModel> models = new ArrayList<AuditModel>();
        List<Audit> audits = this.getAll();
        for (Audit audit : audits) {
            AuditModel model = AuditDaoToAuditModelMapper.auditDaoToModelMapper(audit);
            models.add(model);
        }
        return models;
    }

    @Override
    public AuditModel get(int id) throws ServiceException {
        AuditModel model = null;
        Audit dao = (Audit)this.activeObjects.get(Audit.class, (Object)id);
        if (dao == null) {
            this.LOG.error(this.i18n.getText("termsandconditions.audit.get.fail"));
            throw new ServiceException(this.i18n.getText("termsandconditions.audit.get.fail"));
        }
        model = AuditDaoToAuditModelMapper.auditDaoToModelMapper(dao);
        this.LOG.info("Audit was found with ID: " + id);
        return model;
    }

    @Override
    public AuditModel save(AuditModel model) throws ServiceException {
        Audit dao = model.getId() > 0 ? (Audit)this.activeObjects.get(Audit.class, (Object)model.getId()) : (Audit)this.activeObjects.create(Audit.class, new DBParam[0]);
        dao = AuditDaoToAuditModelMapper.auditModelToDaoMapper(model, dao);
        dao.save();
        this.LOG.info("CREATED - Audit with ID :" + dao.getID());
        return model;
    }

    @Override
    public AuditModel update(AuditModel model) throws ServiceException {
        Audit dao = (Audit)this.activeObjects.get(Audit.class, (Object)model.getId());
        if (dao != null) {
            dao = AuditDaoToAuditModelMapper.auditModelToDaoMapper(model, dao);
            dao.save();
            this.LOG.info("UPDATED - Audit with ID :" + dao.getID());
            return model;
        }
        this.LOG.error(this.i18n.getText("termsandconditions.audit.update.fail"));
        throw new ServiceException(this.i18n.getText("termsandconditions.audit.update.fail"));
    }

    @Override
    public void delete(int id) {
        Audit dao = (Audit)this.activeObjects.get(Audit.class, (Object)id);
        if (dao != null) {
            this.activeObjects.delete(new RawEntity[]{dao});
        }
    }
}

