/*
 * Decompiled with CFR 0.152.
 */
package com.glintech.jira.plugins.termsandconditions.rest;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.glintech.jira.plugins.termsandconditions.ao.Acceptance;
import com.glintech.jira.plugins.termsandconditions.exceptions.ServiceException;
import com.glintech.jira.plugins.termsandconditions.rest.model.TermsAndConditionsModel;
import com.glintech.jira.plugins.termsandconditions.rest.model.UserAcceptanceModel;
import com.glintech.jira.plugins.termsandconditions.service.TermsAndConditionsService;
import com.glintech.jira.plugins.termsandconditions.service.UserAcceptanceService;
import com.glintech.jira.plugins.termsandconditions.util.AcceptanceDaoToAcceptanceModelMapper;
import java.net.URI;
import java.util.Objects;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="tcs")
@Produces(value={"application/json"})
public class TermsAndConditionsController {
    private TermsAndConditionsService TermsAndConditionsService;
    private UserAcceptanceService userAcceptanceService;
    private final PluginLicenseManager licenseManager;
    private final I18nResolver i18n;
    private static final Logger LOG = LoggerFactory.getLogger(TermsAndConditionsController.class);

    @Inject
    public TermsAndConditionsController(TermsAndConditionsService TermsAndConditionsService2, UserAcceptanceService userAcceptanceService, PluginLicenseManager licenseManager, I18nResolver i18n) {
        this.TermsAndConditionsService = TermsAndConditionsService2;
        this.userAcceptanceService = userAcceptanceService;
        this.licenseManager = licenseManager;
        this.i18n = i18n;
    }

    @GET
    @Produces(value={"application/json"})
    public Response get() {
        try {
            if (this.isLicenseValid()) {
                return Response.status((Response.Status)Response.Status.OK).entity(this.TermsAndConditionsService.getList()).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.i18n.getText("termsandconditions.invalid.license")).build();
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Produces(value={"application/json"})
    public Response save(TermsAndConditionsModel model) {
        try {
            if (this.isLicenseValid()) {
                return Response.status((Response.Status)Response.Status.OK).entity((Object)this.TermsAndConditionsService.save(model)).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.i18n.getText("termsandconditions.invalid.license")).build();
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/status/{username}")
    @GET
    @Produces(value={"application/json"})
    public Response getStatus(@PathParam(value="username") String username) {
        try {
            if (this.isLicenseValid()) {
                UserAcceptanceModel model = new UserAcceptanceModel();
                try {
                    Acceptance userAcceptance = this.userAcceptanceService.getByUsername(username);
                    if (!Objects.isNull(userAcceptance)) {
                        model = AcceptanceDaoToAcceptanceModelMapper.mapStatusDaoToUserModel(userAcceptance);
                        if (this.userAcceptanceService.isUserInAcceptedGroup(username)) {
                            model.setUsername(username);
                            model.setAccepted(true);
                            model.setAccepted(true);
                        }
                    } else if (this.userAcceptanceService.isUserInAcceptedGroup(username)) {
                        model.setUsername(username);
                        model.setAccepted(true);
                        model.setAccepted(true);
                        return Response.status((Response.Status)Response.Status.OK).entity((Object)model).build();
                    }
                }
                catch (ServiceException se) {
                    LOG.error(se.getMessage());
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)se.getMessage()).build();
                }
                return Response.status((Response.Status)Response.Status.OK).entity((Object)model).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.i18n.getText("termsandconditions.invalid.license")).build();
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/status")
    @POST
    @Produces(value={"application/json"})
    public Response setStatus(@Context UriInfo uriInfo, @Context HttpServletRequest request, @Context HttpServletResponse response, UserAcceptanceModel model) {
        try {
            if (this.isLicenseValid()) {
                if (this.userAcceptanceService.isUserInAcceptedGroup(model.getUsername())) {
                    return Response.status((Response.Status)Response.Status.OK).entity((Object)model).build();
                }
                UserAcceptanceModel savedModel = this.userAcceptanceService.saveOrUpdate(model);
                if (model.getAccepted().booleanValue()) {
                    return Response.status((Response.Status)Response.Status.OK).entity((Object)savedModel).build();
                }
                String baseUrl = ComponentAccessor.getApplicationProperties().getString("jira.baseurl");
                UriBuilder builder = UriBuilder.fromPath((String)baseUrl).path("/login.jsp");
                URI uri = builder.build(new Object[0]);
                return Response.temporaryRedirect((URI)uri).status(Response.Status.MOVED_PERMANENTLY).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.i18n.getText("termsandconditions.invalid.license")).build();
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    private boolean isLicenseValid() {
        if (this.licenseManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
            return !pluginLicense.getError().isDefined();
        }
        return false;
    }
}

