/*
 * Decompiled with CFR 0.152.
 */
package com.glintech.jira.plugins.termsandconditions.rest;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.glintech.jira.plugins.termsandconditions.ao.Acceptance;
import com.glintech.jira.plugins.termsandconditions.enums.AcceptanceType;
import com.glintech.jira.plugins.termsandconditions.exceptions.ServiceException;
import com.glintech.jira.plugins.termsandconditions.rest.model.AcceptanceModels;
import com.glintech.jira.plugins.termsandconditions.rest.model.FilterModel;
import com.glintech.jira.plugins.termsandconditions.rest.model.GroupAcceptanceModel;
import com.glintech.jira.plugins.termsandconditions.rest.model.TermsAndConditionsModel;
import com.glintech.jira.plugins.termsandconditions.rest.model.UserAcceptanceModel;
import com.glintech.jira.plugins.termsandconditions.service.GroupAcceptanceService;
import com.glintech.jira.plugins.termsandconditions.service.JsdFilterService;
import com.glintech.jira.plugins.termsandconditions.service.TermsAndConditionsService;
import com.glintech.jira.plugins.termsandconditions.service.UserAcceptanceService;
import com.glintech.jira.plugins.termsandconditions.util.AcceptanceDaoToAcceptanceModelMapper;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/admin")
@Produces(value={"application/json"})
public class TermsAndConditionsConfigController {
    private static final Logger LOG = LoggerFactory.getLogger(TermsAndConditionsConfigController.class);
    private TermsAndConditionsService termsAndConditionsService;
    private UserAcceptanceService userAcceptanceService;
    private GroupAcceptanceService groupAcceptanceService;
    private XsrfTokenGenerator xsrfTokenGenerator;
    private JsdFilterService jsdFilterService;
    private final UserManager salUserManager;

    @Inject
    public TermsAndConditionsConfigController(UserAcceptanceService userAcceptanceService, GroupAcceptanceService groupAcceptanceService, TermsAndConditionsService termsAndConditionsService, JsdFilterService jsdFilterService, UserManager salUserManager) {
        if (userAcceptanceService == null && termsAndConditionsService == null) {
            throw new IllegalArgumentException("Required Service classes cannot be null.");
        }
        this.userAcceptanceService = userAcceptanceService;
        this.groupAcceptanceService = groupAcceptanceService;
        this.termsAndConditionsService = termsAndConditionsService;
        this.xsrfTokenGenerator = (XsrfTokenGenerator)ComponentAccessor.getComponentOfType(XsrfTokenGenerator.class);
        this.jsdFilterService = jsdFilterService;
        this.salUserManager = salUserManager;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/config/tcs")
    public Response getTermsAndConditions(@Context HttpServletRequest request) {
        try {
            if (this.isAdmin(request).booleanValue()) {
                List tcs = this.termsAndConditionsService.getList();
                return Response.status((Response.Status)Response.Status.OK).entity(tcs).build();
            }
            LOG.error("Admin access required.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Admin access required.").build();
        }
        catch (ServiceException e) {
            LOG.error(e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/config/tcs")
    public Response updateTermsAndConditions(@Context HttpServletRequest request, TermsAndConditionsModel model) {
        try {
            if (this.isAdmin(request).booleanValue()) {
                return Response.status((Response.Status)Response.Status.OK).entity((Object)this.termsAndConditionsService.update(model)).build();
            }
            LOG.error("Admin access required.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Admin access required.").build();
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PUT
    @Produces(value={"application/json"})
    @Path(value="/config/reset/all")
    public Response resetAll(@Context HttpServletRequest request, @QueryParam(value="type") String type, @QueryParam(value="token") String token) {
        if (!this.isAdmin(request).booleanValue()) {
            LOG.error("Admin access required.");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Admin access required.").build();
        }
        if (!this.xsrfTokenGenerator.validateToken(request, token)) {
            LOG.error("The token provided on request was invalid");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid Token on request").build();
        }
        try {
            if (type.equalsIgnoreCase(AcceptanceType.USER.getType())) {
                this.userAcceptanceService.resetAll();
                return Response.ok((Object)true).build();
            }
            if (!type.equalsIgnoreCase(AcceptanceType.GROUP.getType())) throw new Exception("Invalid type for reset all");
            this.groupAcceptanceService.resetAll();
            return Response.ok((Object)true).build();
        }
        catch (Exception e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getLocalizedMessage()).build();
        }
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/config/reset/{id}")
    public Response resetById(@Context HttpServletRequest request, @QueryParam(value="token") String token, @QueryParam(value="type") String type, @PathParam(value="id") int id) {
        if (this.isAdmin(request).booleanValue()) {
            if (this.xsrfTokenGenerator.validateToken(request, token)) {
                try {
                    if (type.equalsIgnoreCase(AcceptanceType.USER.getType())) {
                        UserAcceptanceModel model = (UserAcceptanceModel)this.userAcceptanceService.getModelById(id);
                        if (model != null) {
                            model.setAccepted(false);
                            this.userAcceptanceService.update(model);
                        }
                        return Response.ok((Object)model).build();
                    }
                    if (type.equalsIgnoreCase(AcceptanceType.GROUP.getType())) {
                        GroupAcceptanceModel model = (GroupAcceptanceModel)this.groupAcceptanceService.getModelById(id);
                        if (model != null) {
                            this.groupAcceptanceService.reset(id);
                        }
                        return Response.ok((Object)model).build();
                    }
                    throw new ServiceException("Invalid type for reset by id");
                }
                catch (ServiceException exception) {
                    LOG.error(exception.getLocalizedMessage(), (Throwable)exception);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exception.getLocalizedMessage()).build();
                }
            }
            LOG.error("The token provided on request was invalid");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid Token on request").build();
        }
        LOG.error("Admin access required.");
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Admin access required.").build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/config/reset")
    public Response resetSelected(@Context HttpServletRequest request, @QueryParam(value="token") String token, @QueryParam(value="type") String type, AcceptanceModels acceptanceModels) {
        if (this.isAdmin(request).booleanValue()) {
            if (this.xsrfTokenGenerator.validateToken(request, token)) {
                try {
                    List<UserAcceptanceModel> models = acceptanceModels.getUserAcceptances();
                    int i = 0;
                    for (UserAcceptanceModel model : models) {
                        model.setAccepted(false);
                        model = AcceptanceDaoToAcceptanceModelMapper.mapStatusDaoToUserModel((Acceptance)this.userAcceptanceService.update(model));
                        models.set(i, model);
                        ++i;
                    }
                    return Response.ok(models).build();
                }
                catch (ServiceException exception) {
                    LOG.error(exception.getLocalizedMessage(), (Throwable)exception);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exception.getLocalizedMessage()).build();
                }
            }
            LOG.error("The token provided on request was invalid");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid Token on request").build();
        }
        LOG.error("Admin access required.");
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Admin access required.").build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/config/list")
    public Response getAcceptancesByType(@Context HttpServletRequest request, @DefaultValue(value="100") @QueryParam(value="limit") int limit, @DefaultValue(value="0") @QueryParam(value="offset") int offset, @QueryParam(value="token") String token, @QueryParam(value="type") String type, @DefaultValue(value="true") @QueryParam(value="jsd") boolean jsd, @DefaultValue(value="true") @QueryParam(value="all") boolean all) {
        if (this.isAdmin(request).booleanValue()) {
            if (this.xsrfTokenGenerator.validateToken(request, token)) {
                try {
                    if (type.equalsIgnoreCase(AcceptanceType.USER.getType())) {
                        List<UserAcceptanceModel> acceptedUsers = this.userAcceptanceService.get(limit, offset);
                        List<UserAcceptanceModel> models = this.filterJsdUser(acceptedUsers, all, jsd);
                        return Response.ok(models).build();
                    }
                    if (type.equalsIgnoreCase(AcceptanceType.GROUP.getType())) {
                        List models = this.groupAcceptanceService.get(limit, offset);
                        return Response.ok(models).build();
                    }
                    throw new ServiceException("Invalid type for getAcceptances");
                }
                catch (ServiceException exception) {
                    LOG.error(exception.getLocalizedMessage(), (Throwable)exception);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exception.getLocalizedMessage()).build();
                }
            }
            LOG.error("The token provided on request was invalid");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid Token on request").build();
        }
        LOG.error("Admin access required.");
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Admin access required.").build();
    }

    private List<UserAcceptanceModel> filterJsdUser(List<UserAcceptanceModel> acceptedUsers, boolean all, boolean jsd) {
        ArrayList<UserAcceptanceModel> models = new ArrayList<UserAcceptanceModel>();
        for (UserAcceptanceModel user : acceptedUsers) {
            if (!user.getAccepted().booleanValue()) continue;
            FilterModel model = new FilterModel();
            ArrayList<String> values = new ArrayList<String>();
            values.add("jsd");
            model.setType("jsd");
            model.setValues(values);
            user.setIsJsd(false);
            if (this.jsdFilterService.isValid(user, model).booleanValue()) {
                user.setFilter(model);
                user.setIsJsd(true);
            }
            if (!jsd && user.isJsd().booleanValue() || !all && !user.isJsd().booleanValue()) continue;
            models.add(0, user);
        }
        return models;
    }

    private Boolean isAdmin(HttpServletRequest request) {
        UserProfile user = this.salUserManager.getRemoteUser(request);
        return this.salUserManager.isSystemAdmin(user.getUserKey());
    }
}

