/*
 * Decompiled with CFR 0.152.
 */
package com.glintech.jira.plugins.termsandconditions.events;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.user.LoginEvent;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.sal.api.message.I18nResolver;
import com.glintech.jira.plugins.termsandconditions.ao.Acceptance;
import com.glintech.jira.plugins.termsandconditions.exceptions.ServiceException;
import com.glintech.jira.plugins.termsandconditions.rest.model.UserAcceptanceModel;
import com.glintech.jira.plugins.termsandconditions.service.UserAcceptanceService;
import com.glintech.jira.plugins.termsandconditions.util.AcceptanceDaoToAcceptanceModelMapper;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class LoginEventListener
implements InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(LoginEventListener.class);
    private final EventPublisher eventPublisher;
    private final I18nResolver i18n;
    private UserAcceptanceService userAcceptanceService;

    public LoginEventListener(EventPublisher eventPublisher, UserAcceptanceService userAcceptanceService, I18nResolver i18n) {
        this.eventPublisher = eventPublisher;
        this.userAcceptanceService = userAcceptanceService;
        this.i18n = i18n;
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onUserLoginEvent(LoginEvent loginEvent) {
        ApplicationUser user = loginEvent.getUser();
        try {
            Acceptance acceptance = this.userAcceptanceService.getByUsername(user.getUsername());
            if (!Objects.isNull(acceptance)) {
                UserAcceptanceModel model = AcceptanceDaoToAcceptanceModelMapper.mapStatusDaoToUserModel(acceptance);
                model.setAccessed(false);
                this.userAcceptanceService.update(model);
            }
        }
        catch (ServiceException e) {
            LOG.error(this.i18n.getText("termsandconditions.login.error"), (Throwable)e);
        }
    }
}

