/*
 * Decompiled with CFR 0.152.
 */
package com.glintech.jira.plugins.termsandconditions.action;

import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.glintech.jira.plugins.termsandconditions.enums.ConfigPath;
import com.glintech.jira.plugins.termsandconditions.enums.Defaults;
import com.glintech.jira.plugins.termsandconditions.exceptions.ServiceException;
import com.glintech.jira.plugins.termsandconditions.exceptions.TermsAndConditionsException;
import com.glintech.jira.plugins.termsandconditions.rest.model.TermsAndConditionsModel;
import com.glintech.jira.plugins.termsandconditions.service.TermsAndConditionsService;
import com.glintech.jira.plugins.termsandconditions.service.UserAcceptanceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SupportedMethods(value={RequestMethod.GET})
public class ConfigAction
extends JiraWebActionSupport {
    private static final long serialVersionUID = 2169146172758656132L;
    private static final Logger LOG = LoggerFactory.getLogger(ConfigAction.class);
    private TermsAndConditionsService termsAndConditionsService;
    private TermsAndConditionsModel termsAndConditions;
    private UserAcceptanceService userAcceptanceService;
    private PermissionManager permissionManager;
    private PluginLicenseManager licenseManager;
    private final I18nResolver i18n;
    private TermsAndConditionsModel tcConfigModel;

    public ConfigAction(TermsAndConditionsService termsAndConditionsService, UserAcceptanceService userAcceptanceService, PermissionManager permissionManager, PluginLicenseManager licenseManager, I18nResolver i18n) {
        this.termsAndConditionsService = termsAndConditionsService;
        this.userAcceptanceService = userAcceptanceService;
        this.permissionManager = permissionManager;
        this.licenseManager = licenseManager;
        this.i18n = i18n;
    }

    @RequiresXsrfCheck
    public String execute() {
        if (!this.isLicenseValid()) {
            return ConfigPath.INVALID_LICENSE.getPath();
        }
        try {
            this.initialiseModels();
            return ConfigPath.VIEW.getPath();
        }
        catch (ServiceException | TermsAndConditionsException e) {
            LOG.error("An error occurred retrieving the Terms and Conditions configuration." + e.getLocalizedMessage());
            return ConfigPath.ERROR.getPath();
        }
    }

    private void initialiseModels() throws TermsAndConditionsException, ServiceException {
        this.tcConfigModel = this.termsAndConditionsService.getByProject(Defaults.PROJECT.getText());
        if (this.tcConfigModel == null) {
            this.tcConfigModel = new TermsAndConditionsModel();
            this.termsAndConditionsService.save(this.tcConfigModel);
        }
    }

    private boolean isLicenseValid() {
        if (this.licenseManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
            return !pluginLicense.getError().isDefined();
        }
        return false;
    }
}

