/*
 * Decompiled with CFR 0.152.
 */
package com.jibrok.jira.plugins.serachbyworkflows.rest;

import com.jibrok.jira.plugins.serachbyworkflows.rest.RestException;
import com.jibrok.jira.plugins.serachbyworkflows.rest.Result;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RestExecutor<T> {
    private static final Logger log = LoggerFactory.getLogger(RestExecutor.class);

    public Response getResponse() {
        return this.getResponse(Response.Status.OK);
    }

    public Response getResponse(Response.Status successStatus) {
        try {
            T actionResult = this.doAction();
            Response.ResponseBuilder responseBuilder = Response.status((Response.Status)successStatus).entity(actionResult);
            if (actionResult instanceof Result) {
                responseBuilder = responseBuilder.entity((Object)((Result)actionResult).getInputStream()).type(((Result)actionResult).getContentType());
            }
            return responseBuilder.build();
        }
        catch (SecurityException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (IllegalArgumentException e) {
            Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage());
            if (e instanceof RestException) {
                responseBuilder = responseBuilder.header("Rest-Exception-Field", (Object)((RestException)e).getField());
            }
            return responseBuilder.build();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e.getMessage()).build();
        }
    }

    protected abstract T doAction() throws Exception;
}

