/*
 * Decompiled with CFR 0.152.
 */
package com.jibrok.jira.plugins.serachbyworkflows.model;

import com.google.gson.Gson;
import com.jibrok.jira.plugins.serachbyworkflows.model.Action;
import com.jibrok.jira.plugins.serachbyworkflows.searcher.FindedArg;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class Workflow
implements Serializable {
    @XmlElement
    private String name;
    @XmlElement
    private List<Action> actions = new ArrayList<Action>();
    private List<FindedArg> rowData = new ArrayList<FindedArg>();
    @XmlElement
    private String error;

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.name);
        oos.writeObject(this.actions);
        oos.writeObject(this.rowData);
        oos.writeObject(this.error);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.name = (String)ois.readObject();
        this.actions = (List)ois.readObject();
        this.rowData = (List)ois.readObject();
        this.error = (String)ois.readObject();
    }

    public Action getFirst() {
        if (this.actions.size() > 0) {
            Action action = this.actions.get(0);
            this.actions.remove(0);
            return action;
        }
        return null;
    }

    public List<FindedArg> getRowData() {
        return this.rowData;
    }

    public void setRowData(List<FindedArg> rowData) {
        this.rowData = rowData;
    }

    public String toString() {
        Gson gson = new Gson();
        return gson.toJson((Object)this);
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public int getCountChild() {
        return this.actions.size();
    }

    public int getAllCountChild() {
        int i = 0;
        for (Action action : this.actions) {
            i += action.getCountChild();
        }
        return i;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Workflow workflow = (Workflow)o;
        return Objects.equals(this.name, workflow.name) && Objects.equals(this.actions, workflow.actions) && Objects.equals(this.rowData, workflow.rowData);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.actions, this.rowData);
    }
}

