/*
 * Decompiled with CFR 0.152.
 */
package com.jibrok.jira.plugins.serachbyworkflows.licence;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.jibrok.jira.plugins.serachbyworkflows.licence.LicenseService;
import com.jibrok.jira.plugins.serachbyworkflows.licence.LicenseStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LicenseServiceImpl
implements LicenseService {
    private final Logger log = LoggerFactory.getLogger(LicenseServiceImpl.class);
    private final PluginLicenseManager pluginLicenseManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Autowired
    public LicenseServiceImpl(PluginLicenseManager pluginLicenseManager, JiraAuthenticationContext jiraAuthenticationContext) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public void checkLicense() throws SecurityException {
        LicenseStatus licenseStatus = this.getLicenseStatus();
        if (!licenseStatus.isValid()) {
            throw new SecurityException(licenseStatus.getErrorMessage());
        }
    }

    @Override
    public LicenseStatus getLicenseStatus() {
        Option licenseOption = this.pluginLicenseManager.getLicense();
        if (licenseOption.isDefined()) {
            PluginLicense license = (PluginLicense)licenseOption.get();
            if (!license.isValid()) {
                Option licenseErrorOption = license.getError();
                if (licenseErrorOption.isDefined()) {
                    LicenseError licenseError = (LicenseError)licenseErrorOption.get();
                    String message = this.jiraAuthenticationContext.getI18nHelper().getText("com.jibrok.jira.plugins.searchbyworkflow.license.error." + licenseError.name());
                    this.log.warn(message);
                    return new LicenseStatus(false, message);
                }
                String message = this.jiraAuthenticationContext.getI18nHelper().getText("com.jibrok.jira.plugins.searchbyworkflow.license.error.INVALID");
                this.log.warn(message);
                return new LicenseStatus(false, message);
            }
        } else {
            String message = this.jiraAuthenticationContext.getI18nHelper().getText("com.jibrok.jira.plugins.searchbyworkflow.license.error.REQUIRED");
            this.log.warn(message);
            return new LicenseStatus(false, message);
        }
        return new LicenseStatus(true, null);
    }
}

