/*
 * Decompiled with CFR 0.152.
 */
package com.jibrok.jira.plugins.serachbyworkflows;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.ManagedCache;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.jibrok.jira.plugins.serachbyworkflows.SearchExecutor;
import com.jibrok.jira.plugins.serachbyworkflows.licence.LicenseService;
import com.jibrok.jira.plugins.serachbyworkflows.licence.LicenseStatus;
import com.jibrok.jira.plugins.serachbyworkflows.model.SearchByWorkflowResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

@SupportedMethods(value={RequestMethod.GET})
public class ViewSearchResultAction
extends JiraWebActionSupport {
    private final CacheManager cacheManager;
    private String taskId;
    private final LicenseService licenseService;

    public ViewSearchResultAction(CacheManager cacheManager, LicenseService licenseService) {
        this.cacheManager = cacheManager;
        this.licenseService = licenseService;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String doDefault() {
        return "input";
    }

    public LicenseStatus getLicenseStatus() {
        return this.licenseService.getLicenseStatus();
    }

    public Object getSearchResult() {
        if (this.taskId == null || this.taskId.isEmpty()) {
            return null;
        }
        Collection managedCaches = this.cacheManager.getManagedCaches();
        for (ManagedCache managedCache : managedCaches) {
            Cache<String, SearchByWorkflowResult> cache;
            if (!managedCache.getName().equals(SearchExecutor.class.getName()) || !(cache = this.getCache()).containsKey((Object)this.taskId)) continue;
            return cache.get((Object)this.taskId);
        }
        return null;
    }

    private Cache<String, SearchByWorkflowResult> getCache() {
        return this.cacheManager.getCache(SearchExecutor.class.getName());
    }

    public boolean hasResults() {
        Cache<String, SearchByWorkflowResult> cache = this.getCache();
        if (cache.getKeys().size() > 1) {
            return true;
        }
        return cache.getKeys().size() == 1 && !cache.getKeys().toString().equals("[]");
    }

    public Map<String, String> getMapTaskSearch() {
        if (!this.hasResults()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> results = new HashMap<String, String>();
        Cache<String, SearchByWorkflowResult> cache = this.getCache();
        for (String taskId : cache.getKeys()) {
            Object searchByWorkflowResult;
            if (!cache.containsKey((Object)taskId) || (searchByWorkflowResult = cache.get((Object)taskId)) == null || !(searchByWorkflowResult instanceof SearchByWorkflowResult)) continue;
            results.put(taskId, ((SearchByWorkflowResult)searchByWorkflowResult).getSearchText());
        }
        return results;
    }

    public Map<String, String> getMapTaskDate() {
        if (!this.hasResults()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> results = new HashMap<String, String>();
        Cache<String, SearchByWorkflowResult> cache = this.getCache();
        for (String taskId : cache.getKeys()) {
            Object searchByWorkflowResult;
            if (!cache.containsKey((Object)taskId) || (searchByWorkflowResult = cache.get((Object)taskId)) == null || !(searchByWorkflowResult instanceof SearchByWorkflowResult)) continue;
            results.put(taskId, ((SearchByWorkflowResult)searchByWorkflowResult).getStringStartDate());
        }
        return results;
    }

    public Map<String, Integer> getAllSearchResults() {
        if (!this.hasResults()) {
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap<String, Integer> results = new LinkedHashMap<String, Integer>();
        final Cache<String, SearchByWorkflowResult> cache = this.getCache();
        ArrayList<String> keys = new ArrayList<String>(cache.getKeys());
        Comparator<String> c = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                SearchByWorkflowResult o1result = (SearchByWorkflowResult)cache.get((Object)o1);
                SearchByWorkflowResult o2result = (SearchByWorkflowResult)cache.get((Object)o2);
                if (o1result == null && o2result == null) {
                    return 0;
                }
                if (o1result == null) {
                    return -1;
                }
                if (o2result == null) {
                    return 1;
                }
                Date o1date = o1result.getStartDate();
                Date o2date = o2result.getStartDate();
                if (o1date == null && o2date == null) {
                    return 0;
                }
                if (o1date == null) {
                    return -1;
                }
                if (o2date == null) {
                    return 1;
                }
                return o1date.compareTo(o2date);
            }
        };
        keys.sort(c);
        for (String taskId : keys) {
            Object searchByWorkflowResult;
            if (!cache.containsKey((Object)taskId) || (searchByWorkflowResult = cache.get((Object)taskId)) == null || !(searchByWorkflowResult instanceof SearchByWorkflowResult)) continue;
            results.put(taskId, ((SearchByWorkflowResult)searchByWorkflowResult).getPercent());
        }
        return results;
    }
}

