/*
 * Decompiled with CFR 0.152.
 */
package com.jibrok.jira.plugins.serachbyworkflows;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.jibrok.jira.plugins.serachbyworkflows.SearchBy;
import com.jibrok.jira.plugins.serachbyworkflows.SearchByWorkflowsTask;
import com.jibrok.jira.plugins.serachbyworkflows.model.SearchByWorkflowResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchExecutor {
    private ExecutorService executorService = Executors.newFixedThreadPool(1);
    private final WorkflowManager workflowManager;
    private final CacheManager cacheManager;
    private final int EXPIRE_AFTER_ACCESS_MINUTES = 60;
    private final int EXPIRE_AFTER_WRITE_MINUTES = 60;
    private final String CACHE_NAME = SearchExecutor.class.getName();
    private Cache<String, SearchByWorkflowResult> cache;
    private int MAX_ENTRIES_DEFAULT = 30;

    @Autowired
    public SearchExecutor(WorkflowManager workflowManager, CacheManager cacheManager) {
        this.workflowManager = workflowManager;
        this.cacheManager = cacheManager;
    }

    public String searchByWorkflows(String text, boolean ignoreCase, SearchBy searchBy, List<String> searchByWorfklows) {
        this.initCache();
        String taskId = this.generateTaskId();
        SearchByWorkflowResult searchByWorkflowResult = new SearchByWorkflowResult();
        searchByWorkflowResult.setSearchText(text);
        searchByWorkflowResult.setSearchBy(searchBy);
        searchByWorkflowResult.setStartDate(new Date());
        this.cache.put((Object)taskId, (Object)searchByWorkflowResult);
        if (searchBy.equals(SearchBy.All)) {
            this.executorService.submit(new SearchByWorkflowsTask(this.workflowManager.getWorkflows(), text, ignoreCase, this.cache, taskId));
        } else if (searchBy.equals(SearchBy.Active)) {
            this.executorService.submit(new SearchByWorkflowsTask(this.workflowManager.getActiveWorkflows(), text, ignoreCase, this.cache, taskId));
        } else if (searchBy.equals(SearchBy.Inactive)) {
            ArrayList<JiraWorkflow> inactive = new ArrayList<JiraWorkflow>();
            Collection workflows = this.workflowManager.getWorkflows();
            Collection activeWorkflows = this.workflowManager.getActiveWorkflows();
            for (JiraWorkflow workflow : workflows) {
                if (activeWorkflows.contains(workflow)) continue;
                inactive.add(workflow);
            }
            this.executorService.submit(new SearchByWorkflowsTask(inactive, text, ignoreCase, this.cache, taskId));
        } else if (searchBy.equals(SearchBy.Selected)) {
            ArrayList<JiraWorkflow> selected = new ArrayList<JiraWorkflow>();
            for (String workflowName : searchByWorfklows) {
                JiraWorkflow workflow = this.workflowManager.getWorkflow(workflowName);
                if (workflow == null) continue;
                selected.add(workflow);
            }
            this.executorService.submit(new SearchByWorkflowsTask(selected, text, ignoreCase, this.cache, taskId));
        }
        return taskId;
    }

    private String generateTaskId() {
        return UUID.randomUUID().toString();
    }

    private void initCache() {
        if (this.cache != null) {
            return;
        }
        CacheSettings required = new CacheSettingsBuilder().remote().expireAfterWrite(60L, TimeUnit.MINUTES).flushable().maxEntries(this.MAX_ENTRIES_DEFAULT).build();
        CacheLoader<String, SearchByWorkflowResult> someCacheLoader = new CacheLoader<String, SearchByWorkflowResult>(){

            @Nonnull
            public SearchByWorkflowResult load(@Nonnull String key) {
                return new SearchByWorkflowResult();
            }
        };
        this.cache = this.cacheManager.getCache(this.CACHE_NAME, (CacheLoader)someCacheLoader, required);
    }
}

