/*
 * Decompiled with CFR 0.152.
 */
package com.jibrok.jira.plugins.serachbyworkflows;

import com.atlassian.cache.Cache;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.jibrok.jira.plugins.serachbyworkflows.model.SearchByWorkflowResult;
import com.jibrok.jira.plugins.serachbyworkflows.model.Workflow;
import com.jibrok.jira.plugins.serachbyworkflows.searcher.FindedArg;
import com.jibrok.jira.plugins.serachbyworkflows.searcher.SearcherByWorkflow;
import com.jibrok.jira.plugins.serachbyworkflows.utils.WorkflowSearchUtils;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchByWorkflowsTask
implements Runnable {
    private static Logger log = LoggerFactory.getLogger((String)SearchByWorkflowsTask.class.getName());
    private Collection<JiraWorkflow> workflows;
    private String text;
    private Cache<String, SearchByWorkflowResult> cache;
    private String taskId;
    private boolean ignoreCase;

    public SearchByWorkflowsTask(Collection<JiraWorkflow> workflows, String text, boolean ignoreCase, Cache<String, SearchByWorkflowResult> cache, String taskId) {
        this.text = text;
        this.workflows = workflows;
        this.cache = cache;
        this.taskId = taskId;
        this.ignoreCase = ignoreCase;
    }

    @Override
    public void run() {
        int i = 0;
        for (JiraWorkflow workflow : this.workflows) {
            ++i;
            if (workflow == null) continue;
            int percent = i * 10 / this.workflows.size() * 10;
            try {
                Workflow result = this.searchByWorkflow(workflow, this.text, this.ignoreCase);
                SearchByWorkflowResult searchByWorkflowResult = (SearchByWorkflowResult)this.cache.get((Object)this.taskId);
                if (searchByWorkflowResult == null) {
                    throw new Exception("Search by workflows: searchByWorkflowResult is empty, please send it vendor.");
                }
                if (result == null) {
                    searchByWorkflowResult.setPercent(percent);
                    this.cache.put((Object)this.taskId, (Object)searchByWorkflowResult);
                    continue;
                }
                searchByWorkflowResult.getResult().add(result);
                searchByWorkflowResult.setPercent(percent);
                this.cache.put((Object)this.taskId, (Object)searchByWorkflowResult);
            }
            catch (Exception e) {
                log.error(e.toString());
            }
        }
    }

    private Workflow searchByWorkflow(JiraWorkflow workflow, String searchText, boolean ignoreCase) {
        SearcherByWorkflow searcherByWorkflow = new SearcherByWorkflow();
        ArrayList<FindedArg> search = new ArrayList();
        Exception error = null;
        try {
            search = searcherByWorkflow.search(workflow, searchText, ignoreCase);
        }
        catch (Exception e) {
            error = e;
            log.error(e.toString());
        }
        Workflow result = WorkflowSearchUtils.convertSearchResultToWorkflow(search, workflow.getName(), error);
        return result;
    }
}

