/*
 * Decompiled with CFR 0.152.
 */
package com.jibrok.jira.plugins.serachbyworkflows;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.jibrok.jira.plugins.serachbyworkflows.SearchDto;
import com.jibrok.jira.plugins.serachbyworkflows.SearchExecutor;
import com.jibrok.jira.plugins.serachbyworkflows.TaskDto;
import com.jibrok.jira.plugins.serachbyworkflows.licence.LicenseService;
import com.jibrok.jira.plugins.serachbyworkflows.rest.RestExecutor;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.stereotype.Component;

@Path(value="/search")
@Produces(value={"application/json"})
@Component
public class SearchByWorkflowsRest {
    private final SearchExecutor searchExecutor;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final LicenseService licenseService;

    public SearchByWorkflowsRest(SearchExecutor searchExecutor, JiraAuthenticationContext jiraAuthenticationContext, LicenseService licenseService) {
        this.searchExecutor = searchExecutor;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.licenseService = licenseService;
    }

    @POST
    public Response runSearch(final SearchDto searchDto) {
        return new RestExecutor<TaskDto>(){

            @Override
            protected TaskDto doAction() {
                SearchByWorkflowsRest.this.licenseService.checkLicense();
                if (!SearchByWorkflowsRest.this.jiraAuthenticationContext.isLoggedInUser()) {
                    throw new SecurityException();
                }
                String taskId = SearchByWorkflowsRest.this.searchExecutor.searchByWorkflows(searchDto.getSearchText(), searchDto.getCaseIgnore(), searchDto.getSearchBy(), searchDto.getSelectedWorkflows());
                return new TaskDto(taskId);
            }
        }.getResponse();
    }
}

