/*
 * Decompiled with CFR 0.152.
 */
package com.jibrok.jira.plugins.serachbyworkflows;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.jibrok.jira.plugins.serachbyworkflows.SearchBy;
import com.jibrok.jira.plugins.serachbyworkflows.SearchExecutor;
import com.jibrok.jira.plugins.serachbyworkflows.licence.LicenseService;
import com.jibrok.jira.plugins.serachbyworkflows.licence.LicenseStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@SupportedMethods(value={RequestMethod.GET})
public class SearchByWorkflowsAction
extends JiraWebActionSupport {
    private final SearchExecutor searchExecutor;
    private final WorkflowManager workflowManager;
    private String searchText;
    private String searchBy;
    private String selectedWorkflows = "";
    private String ignoreCase;
    private String baseUrl = ComponentAccessor.getApplicationProperties().getString("jira.baseurl");
    private final LicenseService licenseService;

    public SearchByWorkflowsAction(SearchExecutor searchExecutor, WorkflowManager workflowManager, LicenseService licenseService) {
        this.searchExecutor = searchExecutor;
        this.workflowManager = workflowManager;
        this.licenseService = licenseService;
    }

    public LicenseStatus getLicenseStatus() {
        return this.licenseService.getLicenseStatus();
    }

    public String getSelectedWorkflows() {
        return this.selectedWorkflows;
    }

    public void setSelectedWorkflows(String selectedWorkflows) {
        this.selectedWorkflows = selectedWorkflows;
    }

    public String getSearchBy() {
        return this.searchBy;
    }

    public void setSearchBy(String searchBy) {
        this.searchBy = searchBy;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public String getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(String ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String doDefault() {
        return "input";
    }

    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() {
        this.licenseService.checkLicense();
        boolean caseIgnore = Boolean.valueOf(this.ignoreCase);
        String taskId = this.searchExecutor.searchByWorkflows(this.searchText, caseIgnore, SearchBy.valueOf(this.searchBy), Arrays.asList(this.selectedWorkflows.split(", ")));
        return this.getRedirect("jibrokSearchByWorkflowsView!default.jspa?taskId=" + taskId);
    }

    protected void doValidation() {
        if (this.searchText == null || this.searchText.isEmpty() || this.searchText.trim().isEmpty()) {
            this.addErrorMessage(this.getText("com.jibrok.jira.plugins.simplenotifications.message.validation.error.type"));
        }
        super.doValidation();
    }

    public List<String> getAllWorkflows() {
        ArrayList<String> all = new ArrayList<String>();
        for (JiraWorkflow workflow : this.workflowManager.getWorkflows()) {
            all.add(workflow.getName());
        }
        return all;
    }
}

