/*
 * Decompiled with CFR 0.152.
 */
package ee.narwhals.IssuePlus.servlet;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueHistoryPdfExport
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(IssueHistoryPdfExport.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        IssueManager issueManager = ComponentAccessor.getIssueManager();
        String id = req.getParameter("id");
        Long idl = Long.parseLong(id);
        String issueKey = issueManager.getIssueObject(idl).getKey();
        String exportFileName = "\"IssuePlus_" + issueKey + "_HistoryExport.pdf\"";
        BaseColor baseColor = new BaseColor(222, 235, 255);
        try {
            Document document = new Document();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PdfWriter.getInstance(document, baos);
            document.open();
            Font titleFont = FontFactory.getFont("Helvetica-Bold", 20.0f);
            Font footerFont = FontFactory.getFont("Helvetica-Oblique", 10.0f);
            Font headerFont = FontFactory.getFont("Helvetica-Bold", 12.0f);
            Font textFont = FontFactory.getFont("Helvetica", 11.0f);
            titleFont.setColor(0, 82, 204);
            footerFont.setColor(0, 82, 204);
            headerFont.setColor(23, 43, 77);
            textFont.setColor(23, 43, 77);
            Phrase title = new Phrase("Issue History Export for " + issueKey, titleFont);
            document.add(title);
            PdfPTable table = new PdfPTable(5);
            table.setWidths(new int[]{6, 5, 5, 7, 7});
            PdfPCell cell = new PdfPCell(new Paragraph("Timestamp", headerFont));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(1);
            cell.setBackgroundColor(baseColor);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("Author", headerFont));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(1);
            cell.setBackgroundColor(baseColor);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("Field", headerFont));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(1);
            cell.setBackgroundColor(baseColor);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("Old Value", headerFont));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(1);
            cell.setBackgroundColor(baseColor);
            table.addCell(cell);
            cell = new PdfPCell(new Phrase("New Value", headerFont));
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(1);
            cell.setBackgroundColor(baseColor);
            table.addCell(cell);
            List changes = ComponentAccessor.getChangeHistoryManager().getChangeHistories((Issue)issueManager.getIssueByCurrentKey(issueKey));
            for (int i = 0; i < changes.size(); ++i) {
                ChangeHistory changeHistory = (ChangeHistory)changes.get(i);
                String changeAuthor = changeHistory.getAuthorDisplayName();
                Timestamp changeTime = changeHistory.getTimePerformed();
                String changeTimeFormatted = new SimpleDateFormat("dd.MM.yyyy HH:mm").format(changeTime);
                List changeItemBeanList = changeHistory.getChangeItems();
                for (int k = 0; k < changeItemBeanList.size(); ++k) {
                    String changeField = "";
                    String oldValue = "";
                    String newValue = "";
                    changeField = ((GenericValue)changeItemBeanList.get(k)).get("field") == null ? "" : ((GenericValue)changeItemBeanList.get(k)).get("field").toString();
                    oldValue = ((GenericValue)changeItemBeanList.get(k)).get("oldstring") == null ? "" : ((GenericValue)changeItemBeanList.get(k)).get("oldstring").toString();
                    newValue = ((GenericValue)changeItemBeanList.get(k)).get("newstring") == null ? "" : ((GenericValue)changeItemBeanList.get(k)).get("newstring").toString();
                    String tempIssueHistoryResult = changeTimeFormatted + ";" + changeAuthor + ";" + changeField + ";" + oldValue + ";" + newValue + ";\n";
                    table.addCell(new Phrase(changeTimeFormatted, textFont));
                    table.addCell(new Phrase(changeAuthor, textFont));
                    table.addCell(new Phrase(changeField, textFont));
                    table.addCell(new Phrase(oldValue, textFont));
                    table.addCell(new Phrase(newValue, textFont));
                }
            }
            document.add(table);
            Paragraph footer = new Paragraph("Generated by IssuePlus add-on", footerFont);
            footer.setAlignment(2);
            document.add(footer);
            document.close();
            resp.setHeader("Expires", "0");
            resp.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
            resp.setHeader("Pragma", "public");
            resp.setContentType("application/pdf;charset=UTF-8");
            resp.addHeader("Content-Disposition", "attachment; filename=" + exportFileName);
            resp.setContentLength(baos.size());
            ServletOutputStream os = resp.getOutputStream();
            baos.writeTo((OutputStream)os);
            os.flush();
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

