/*
 * Decompiled with CFR 0.152.
 */
package ee.narwhals.IssuePlus.servlet;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
public class IssueHistoryExport
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(IssueHistoryExport.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        IssueManager issueManager = ComponentAccessor.getIssueManager();
        String id = req.getParameter("id");
        Long idl = Long.parseLong(id);
        String issueKey = issueManager.getIssueObject(idl).getKey();
        resp.setContentType("text/csv");
        String exportFileName = "\"IssuePlus_" + issueKey + "_HistoryExport.csv\"";
        resp.setHeader("Content-Disposition", "attachment; filename=" + exportFileName);
        try {
            ServletOutputStream outputStream = resp.getOutputStream();
            String issueHistoryResult = "Timestamp;Change Author;Change Field;Old Value;New Value;\n";
            List changes = ComponentAccessor.getChangeHistoryManager().getChangeHistories((Issue)issueManager.getIssueByCurrentKey(issueKey));
            for (int i = 0; i < changes.size(); ++i) {
                ChangeHistory changeHistory = (ChangeHistory)changes.get(i);
                String changeAuthor = changeHistory.getAuthorDisplayName();
                Timestamp changeTime = changeHistory.getTimePerformed();
                String changeTimeFormatted = new SimpleDateFormat("dd.MM.yyyy HH:mm").format(changeTime);
                List changeItemBeanList = changeHistory.getChangeItems();
                for (int k = 0; k < changeItemBeanList.size(); ++k) {
                    String changeField = "";
                    String oldValue = "";
                    String newValue = "";
                    changeField = ((GenericValue)changeItemBeanList.get(k)).get("field") == null ? "" : ((GenericValue)changeItemBeanList.get(k)).get("field").toString();
                    oldValue = ((GenericValue)changeItemBeanList.get(k)).get("oldstring") == null ? "" : ((GenericValue)changeItemBeanList.get(k)).get("oldstring").toString();
                    newValue = ((GenericValue)changeItemBeanList.get(k)).get("newstring") == null ? "" : ((GenericValue)changeItemBeanList.get(k)).get("newstring").toString();
                    String tempIssueHistoryResult = changeTimeFormatted + ";" + changeAuthor + ";" + changeField + ";" + oldValue + ";" + newValue + ";\n";
                    issueHistoryResult = issueHistoryResult + tempIssueHistoryResult;
                }
            }
            outputStream.write(issueHistoryResult.getBytes());
            outputStream.flush();
            outputStream.close();
            issueHistoryResult = "";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

