/*
 * Decompiled with CFR 0.152.
 */
package ee.narwhals.IssuePlus.search;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProviderFactoryImpl;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.plugin.searchrequestview.AbstractSearchRequestView;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestParams;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.sal.api.search.SearchProvider;
import java.io.IOException;
import java.io.Writer;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class JQLHistoryExport2CSV
extends AbstractSearchRequestView {
    public void writeSearchResults(SearchRequest searchRequest, SearchRequestParams searchRequestParams, Writer writer) throws SearchException {
        JiraAuthenticationContext authenticationContext = ComponentAccessor.getJiraAuthenticationContext();
        IssueFactory issueFactory = ComponentAccessor.getIssueFactory();
        SearchProvider searchProvider = (SearchProvider)ComponentAccessor.getComponent(SearchProvider.class);
        SearchService searchService = (SearchService)ComponentAccessor.getComponent(SearchService.class);
        SearchProviderFactoryImpl searchProviderFactory = (SearchProviderFactoryImpl)ComponentAccessor.getComponent(SearchProviderFactoryImpl.class);
        Map defaultParams = JiraVelocityUtils.getDefaultVelocityParams((JiraAuthenticationContext)authenticationContext);
        HashMap<String, String> headerParams = new HashMap<String, String>();
        ApplicationUser user = authenticationContext.getLoggedInUser();
        headerParams.put("filtername", searchRequest.getName());
        headerParams.put("user", user.getDisplayName());
        try {
            writer.write(this.descriptor.getHtml("header", headerParams));
            HashMap<String, String> issueParams = new HashMap<String, String>(defaultParams);
            SearchResults searchResults = searchService.search(user, searchRequest.getQuery(), searchRequestParams.getPagerFilter());
            List issues = searchResults.getResults();
            for (int i = 0; i < issues.size(); ++i) {
                String historyParams = this.getIssueHistories((Issue)issues.get(i));
                issueParams.put("history", historyParams);
                writer.write(this.descriptor.getHtml("singleissue", issueParams));
            }
            writer.write(this.descriptor.getHtml("footer", MapBuilder.build((Object)"user", (Object)authenticationContext.getLoggedInUser())));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getIssueHistories(Issue issue) {
        HashMap<String, String> issueHistoryValues = new HashMap<String, String>();
        String issueKey = issue.getKey();
        List changes = ComponentAccessor.getChangeHistoryManager().getChangeHistories(issue);
        String issueHistoryResult = "";
        for (int i = 0; i < changes.size(); ++i) {
            ChangeHistory changeHistory = (ChangeHistory)changes.get(i);
            String changeAuthor = changeHistory.getAuthorDisplayName();
            Timestamp changeTime = changeHistory.getTimePerformed();
            String changeTimeFormatted = new SimpleDateFormat("dd.MM.yyyy HH:mm").format(changeTime);
            List changeItemBeanList = changeHistory.getChangeItems();
            for (int k = 0; k < changeItemBeanList.size(); ++k) {
                String changeField = "";
                String oldValue = "";
                String newValue = "";
                changeField = ((GenericValue)changeItemBeanList.get(k)).get("field") == null ? "" : ((GenericValue)changeItemBeanList.get(k)).get("field").toString();
                oldValue = ((GenericValue)changeItemBeanList.get(k)).get("oldstring") == null ? "" : ((GenericValue)changeItemBeanList.get(k)).get("oldstring").toString();
                newValue = ((GenericValue)changeItemBeanList.get(k)).get("newstring") == null ? "" : ((GenericValue)changeItemBeanList.get(k)).get("newstring").toString();
                String tempIssueHistoryResult = issueKey + ";" + changeTimeFormatted + ";" + changeAuthor + ";" + changeField + ";" + oldValue + ";" + newValue + ";\n";
                issueHistoryResult = issueHistoryResult + tempIssueHistoryResult;
            }
            issueHistoryValues.put("history", issueHistoryResult);
        }
        return issueHistoryResult;
    }
}

