/*
 *     This file is part of the Xsquash plugin for JIRA.
 *     Copyright (C) 2018 - 2019 Henix - All Rights Reserved
 *
 *     Unauthorized copying of this file, via any medium is strictly prohibited
 *     Proprietary and confidential
 *
 * 	 (C)Henix. Tous droits réservés.
 *
 * 	Avertissement : ce programme est protégé par la loi relative au droit d'auteur et par les conventions internationales. Toute reproduction ou distribution partielle ou totale du logiciel, par quelque moyen que ce soit, est strictement interdite.
 */
var projectConfig;
var baseUrl = AJS.$("meta[name='ajs-context-path']").attr("content");

AJS.$(function () {
    JIRA.bind(JIRA.Events.NEW_CONTENT_ADDED, function(e, context, reason) {
        var $context = AJS.$(context);

        if(reason === JIRA.CONTENT_ADDED_REASON.panelRefreshed){
            if(projectConfig === undefined){
                var issueKey = $context.find("#key-val").text();
                var issueKeySplit = issueKey.split('-');
                if(issueKeySplit !== undefined && issueKeySplit !== ""){
                    AJS.$.ajax({
                        url: baseUrl + "/rest/Xsquash-admin/1.0/project-config/"+issueKeySplit[0],
                        dataType: "json"
                    }).done(function(config){
                        projectConfig = config;
                        updateXsquashTabName();
                    });
                }
            }
        }
    });
});

JIRA.ViewIssueTabs.onTabReady(updateXsquashTabName);

function updateXsquashTabName(){
    if(!!projectConfig && projectConfig.isActivated) {
        var testCasesTabName = projectConfig.testCasesTabName;
        var executionsTabName = projectConfig.executionsTabName;
        if(executionsTabName !== null && executionsTabName !== ""){
            AJS.$("#squash-executions-issue-tab-panel").attr("data-label", executionsTabName);
            AJS.$("#squash-executions-issue-tab-panel a").text(executionsTabName);
            // For JIRA version <= 7.9
            AJS.$("#squash-executions-issue-tab-panel strong").text(executionsTabName);
        }
        if(testCasesTabName !== null && testCasesTabName !== ""){
            AJS.$("#squash-test-cases-issue-tab-panel").attr("data-label", testCasesTabName);
            AJS.$("#squash-test-cases-issue-tab-panel a").text(testCasesTabName);
            // For JIRA version <= 7.9
            AJS.$("#squash-test-cases-issue-tab-panel strong").text(testCasesTabName);
        }
    }
}

