/*
 *     This file is part of the Xsquash plugin for JIRA.
 *     Copyright (C) 2018 - 2019 Henix - All Rights Reserved
 *
 *     Unauthorized copying of this file, via any medium is strictly prohibited
 *     Proprietary and confidential
 *
 * 	 (C)Henix. Tous droits réservés.
 *
 * 	Avertissement : ce programme est protégé par la loi relative au droit d'auteur et par les conventions internationales. Toute reproduction ou distribution partielle ou totale du logiciel, par quelque moyen que ce soit, est strictement interdite.
 */
var baseUrl = AJS.$("meta[name='ajs-context-path']").attr("content");
AJS.$(function () {
    if(document.getElementById('squash-project-admin-link') !== null){
        JIRA.Dialogs.xsquashConfig = new JIRA.Dialog({
            id: "xsquash-config-dialog",
            trigger: "#squash-project-admin-link",
            ajaxOptions: JIRA.Dialogs.getDefaultAjaxOptions
        });

        // execute on popup display
        JIRA.bind(JIRA.Events.NEW_CONTENT_ADDED, function(e, context, reason) {
            var $context = AJS.$(context);

            // for dialog only
            if(reason === JIRA.CONTENT_ADDED_REASON.dialogReady){
                populateProjectConfigForm();

                $context.find("#project-admin").submit(function(e) {
                    e.preventDefault();
                    var squashServerUuid = $context.find("#squash-server-single-select").attr("value");
                    var pluginActivation = $context.find("#pluginActivation").attr("checked");
                    var executionsTabName = $context.find("#squash-execution-tab-panel-name").attr("value");
                    var testCasesTabName = $context.find("#squash-test-case-tab-panel-name").attr("value");

                    if(squashServerUuid === "0"){
                        $context.find("#error-message").addClass("aui-message aui-message-error");
                        $context.find("#error-message p").text(AJS.I18n.getText("project-administration.save-settings.missing-data.label"));
                    } else{
                        updateProjectConfig(squashServerUuid, pluginActivation, testCasesTabName, executionsTabName);
                    }
                });

                $context.find("#closeButton").click(function(e) {
                    e.preventDefault();
                    JIRA.Dialogs.xsquashConfig.hide();
                });
            }
        });
    }
});

function updateProjectConfig(squashServerUuid, pluginActivation,testCasesTabName, executionsTabName) {
    var isActivated = pluginActivation === "checked";
    if(squashServerUuid === "0"){
        squashServerUuid ="";
    }
    let xsquashProjectConfig = {
        projectKey: AJS.$("meta[name='projectKey']").attr('content'),
        serverUuid: squashServerUuid,
        isActivated: isActivated,
        testCasesTabName: testCasesTabName,
        executionsTabName: executionsTabName
    };
    AJS.$.ajax({
        url: baseUrl + "/rest/Xsquash-admin/1.0/project-config",
        type: "PUT",
        contentType: "application/json",
        data: JSON.stringify(xsquashProjectConfig),
        processData: false
    }).done(function(){
        var message = AJS.I18n.getText("project-administration.save-settings.success.label");
        JIRA.Dialogs.xsquashConfig.hide();
        JIRA.Messages.showSuccessMsg(message);
    }).fail(function(XMLHttpRequest, textStatus, errorThrown){
        AJS.$("#error-message").addClass("aui-message aui-message-error");
        AJS.$("#error-message p").text(AJS.I18n.getText("project-administration.save-settings.error.label", textStatus));
    });
}

function populateProjectConfigForm() {
    AJS.$.ajax({
        url: baseUrl + "/rest/Xsquash-admin/1.0/project-config/"+AJS.$("meta[name='projectKey']").attr('content'),
        dataType: "json"
    }).done(function(config) {
        if(config !== null) {
            var squashServerSelectQuerySelector = '#squash-server-single-select';
            var serverUuid = config.serverUuid === "" ? "0" : config.serverUuid;
            AJS.$(squashServerSelectQuerySelector).attr('value', serverUuid);
            AJS.$("#pluginActivation").attr("checked", config.isActivated);
            if(config.executionsTabName !== null && config.executionsTabName !== ""){
                AJS.$("#squash-execution-tab-panel-name").attr("value", config.executionsTabName);
            }
            if(config.testCasesTabName !== null && config.testCasesTabName !== ""){
                AJS.$("#squash-test-case-tab-panel-name").attr("value", config.testCasesTabName);
            }
        }
    });
}
