/*
 *     This file is part of the Xsquash plugin for JIRA.
 *     Copyright (C) 2018 - 2022 Henix - All Rights Reserved
 *
 *     Unauthorized copying of this file, via any medium is strictly prohibited
 *     Proprietary and confidential
 *
 * 	 (C)Henix. Tous droits réservés.
 *
 * 	Avertissement : ce programme est protégé par la loi relative au droit d'auteur et par les conventions internationales. Toute reproduction ou distribution partielle ou totale du logiciel, par quelque moyen que ce soit, est strictement interdite.
 */
JIRA.ViewIssueTabs.onTabReady(function () {
    // Looking for class "active-tab" for recent JIRA version and "active" for old ones (JIRA 7.8.0 for example)
    if (AJS.$("#squash-test-cases-issue-tab-panel").hasClass("active-tab") || AJS.$("#squash-test-cases-issue-tab-panel").hasClass("active")) {
        AJS.$(".withToolTip").tooltip();
        let arrows = AJS.$(".arrowTestCase");
        arrows.off('click').on('click', displayDetails);
        AJS.$("#testCases tr.more").hide();
    } else if (AJS.$("#squash-executions-issue-tab-panel").hasClass("active-tab") || AJS.$("#squash-executions-issue-tab-panel").hasClass("active")) {
        AJS.$("#executions tr.more").hide();
        AJS.$(".withToolTip").tooltip();
        let arrows = AJS.$(".arrowExecution");
        arrows.off('click').on('click', displayDetails);
        let stepArrows = AJS.$(".arrowExecutionStep");
        stepArrows.off('click').on('click', displayStepDetails);
    }
});

function displayStepDetails() {
    var more = AJS.$(this).closest("tr").next("tr");
    more.toggle();
    AJS.$(this).toggleClass("up");
}

function displayDetails() {
    var more = AJS.$(this).closest("tr").next("tr");
    more.toggle();
    AJS.$(this).toggleClass("up");
    var editorDiv = more.find("#editor")[0];
    if (AJS.$(this).hasClass("up") && editorDiv) {
        _initAceEditor(editorDiv);
    }
}

function _initialize_editor_mode(editor) {
    var locale = _findScriptLocale(editor);

    var aceEditorMode;
    if (locale === "en") {
        aceEditorMode = "ace/mode/gherkin";
    } else {
        aceEditorMode = "ace/mode/gherkin-" + locale;
    }
    editor.session.setMode(aceEditorMode);
}

function _findScriptLocale(editor) {
    var line0 = editor.session.getLine(0);
    var locale;
    if (line0 !== null) {
        line0 = line0.trim();
        if (line0.search("language:") !== -1) {
            var parsedLocale = line0.substring(line0.length - 2);
            switch (parsedLocale) {
                case "fr" :
                    locale = "fr";
                    break;
                case "de" :
                    locale = "de";
                    break;
                case "es" :
                    locale = "es";
                    break;
                default:
                    locale = 'en';
                    console.log("Unable to find locale from parsed locale : " + parsedLocale + ". Default to en.");
            }
        }
    }
    return locale;
}

function htmlDecode(input) {
    var doc = new DOMParser().parseFromString(input, "text/html");
    return doc.documentElement.textContent;
}

function _initAceEditor(editorDiv) {
    var editor = ace.edit(editorDiv);
    editor.setTheme("ace/theme/chrome-grey");
    editor.setOptions({
        readOnly: true,
        highlightActiveLine: false,
        tabSize: 2,
        useSoftTabs: 2
    });
    var script = htmlDecode(AJS.$(editorDiv).prev("#script").html());
    editor.session.setValue(script);
    _initialize_editor_mode(editor);
    editor.container.style.lineHeight = "14px";
    editor.renderer.updateFontSize();
    editorDiv.style.height = editor.renderer.lineHeight * editor.getSession().getDocument().getLength() + "px";
    editor.resize();
}

function sortTable(cell) {

    var rows, unsorted, i, row, nextRow, shouldSwitch, dir, n, table, switchcount = 0, unsorted = true;
    n = cell.cellIndex;
    console.log (n);
    table = cell.parentNode.parentNode.parentNode;

    console.log (table.tHead.rows[0].cells[n]);
    dir = table.tHead.rows[0].cells[n].getAttribute('data-dir') == "unsort" ? "asc" : table.tHead.rows[0].cells[n].getAttribute('data-dir');
    unsortPreviousSortedColumn(n, table);


    while (unsorted) {
        //start by saying: no unsorted is done:
        unsorted = false;
        rows = table.rows;

        /*Loop through all table rows (except the
        first, which contains table headers):*/
        for (i = 1; i < (rows.length - 2); i += 2) {
            //start by saying there should be no unsorted:
            shouldSwitch = false;
            /*Get the two <tr> you want to compare*/
            row = rows[i].getElementsByTagName("TD")[n];
            nextRow = rows[i + 2].getElementsByTagName("TD")[n];


            /*check if the two rows should switch,
          based on the direction, asc or desc:*/

            if (row.getAttribute('data-value-type') === "date") {
               if (dir === "asc") {
                    if (Date.parse(row.getAttribute('data-value')) > Date.parse(nextRow.getAttribute('data-value'))) {
                        shouldSwitch = true;
                        break;
                    }
                } else if (dir === "desc") {
                    if (Date.parse(row.getAttribute('data-value')) < Date.parse(nextRow.getAttribute('data-value'))) {
                        shouldSwitch = true;
                        break;
                    }
                }

            } else if (isNaN(row.getAttribute('data-value'))) {
                if (dir === "asc") {
                    if (String(row.getAttribute('data-value').toLowerCase()).localeCompare(String(nextRow.getAttribute('data-value').toLowerCase())) == 1) {
                        shouldSwitch = true;
                        break;
                    }
                } else if (dir === "desc") {
                    if (String(row.getAttribute('data-value').toLowerCase()).localeCompare(String(nextRow.getAttribute('data-value').toLowerCase())) == -1) {
                        shouldSwitch = true;
                        break;
                    }
                }

            } else {
                if (dir === "asc") {
                    if (parseInt(row.getAttribute('data-value'), 10) > parseInt(nextRow.getAttribute('data-value'), 10)) {
                        shouldSwitch = true;
                        break;
                    }
                } else if (dir === "desc") {
                    if (parseInt(row.getAttribute('data-value'), 10) < parseInt(nextRow.getAttribute('data-value'), 10)) {
                        shouldSwitch = true;
                        break;
                    }
                }

            }

        }

        if (shouldSwitch) {
            /*If a switch has been marked, make the switch
          and mark that a switch has been done:*/
            rows[i].parentNode.insertBefore(rows[i + 3], rows[i]);
            rows[i].parentNode.insertBefore(rows[i + 3], rows[i]);

            unsorted = true;
            //Each time a switch is done, increase by 1:
            switchcount++;

        } else {

            switch (dir) {
                case "unsort":
                    dir = "asc";
                    table.tHead.rows[0].cells[n].setAttribute('data-dir', 'asc');
                    break;
                case "asc":
                    table.tHead.rows[0].cells[n].setAttribute('data-dir', 'desc');
                    break;
                case "desc":
                    table.tHead.rows[0].cells[n].setAttribute('data-dir', 'asc');
                    break;
                default:
                    break;
            }
        }

    }

}

function unsortPreviousSortedColumn(n, table) {
    for (var k = 0; k < table.tHead.rows[0].cells.length; k++) {
        if (k != n) {
            table.tHead.rows[0].cells[k].setAttribute('data-dir', 'unsort')
        }
    }
}

