/*
 *     This file is part of the Xsquash plugin for JIRA.
 *     Copyright (C) 2018 - 2019 Henix - All Rights Reserved
 *
 *     Unauthorized copying of this file, via any medium is strictly prohibited
 *     Proprietary and confidential
 *
 * 	 (C)Henix. Tous droits réservés.
 *
 * 	Avertissement : ce programme est protégé par la loi relative au droit d'auteur et par les conventions internationales. Toute reproduction ou distribution partielle ou totale du logiciel, par quelque moyen que ce soit, est strictement interdite.
 */
var baseUrl = AJS.$("meta[name='ajs-context-path']").attr("content");

AJS.toInit(function () {

        var rt = new AJS.RestfulTable({
            el: jQuery("#server-config-table"),
            autoFocus: false,
            allowCreate: false,
            allowEdit: false,
            allowDelete: true,
            noEntriesMsg: AJS.I18n.getText("global-administration-no-server.label"),
            loadingMsg: AJS.I18n.getText("global-administration-loading-table.message"),
            createPosition: "bottom",
            resources: {
                all: baseUrl + "/rest/Xsquash-admin/1.0/server-config",
                self: baseUrl + "/rest/Xsquash-admin/1.0/server-config"
            },
            columns: [
                {
                    id: "id",
                    header: "id",
                    allowEdit: false,
                },
                {
                    id: "squashServerNameInJira",
                    header: AJS.I18n.getText("global-administration-dialog.name.label"),
                    allowEdit: false
                },
                {
                    id: "squashURL",
                    header: AJS.I18n.getText("global-administration-dialog.squash-url.label"),
                    allowEdit: false,
                },
                {
                    id: "jiraServerNameInSquash",
                    header: AJS.I18n.getText("global-administration-dialog.server-name.label"),
                    allowEdit: false,
                },
                {
                    id: "authentication-mode",
                    header: AJS.I18n.getText("global-administration-dialog.auth-mode.label"),
                    allowEdit: false,
                    readView: AJS.RestfulTable.CustomReadView.extend({
                        render: function (self) {
                            return inferAuthMode(this.model);
                        }
                    })
                },
                {
                    id: "login",
                    header: AJS.I18n.getText("global-administration-dialog.login.label"),
                    allowEdit: false
                },
                {
                    id: "update-button",
                    header: "",
                    allowEdit: false,
                    readView: AJS.RestfulTable.CustomReadView.extend({
                        render: function (self) {
                            var id = this.model.get("id");
                            return `<a class="admin-btn add-squash-server-link" href="Xsquash/new-server?uuid=${id}"><span class="aui-icon aui-icon-small aui-iconfont-edit-filled aui-iconfont-edit">Edit Server</span></a>`;
                        }
                    })
                },
                {
                    id: "status",
                    header: "",
                    allowEdit: false,
                    readView: AJS.RestfulTable.CustomReadView.extend({
                        render: function (self) {
                            var id = this.model.get("id");
                            return `<aui-spinner class="spinner-${id}" size="small"></aui-spinner><div id=${id} class="server-status"></div>`
                        }
                    })
                },
                {
                    id: "refresh-button",
                    header: "",
                    allowEdit: false,
                    readView: AJS.RestfulTable.CustomReadView.extend({
                        render: function (self) {
                            var id = this.model.get("id");
                            return `<button onclick="checkSquashServerStatus(${id})" class="admin-btn"><span class=\"aui-icon aui-icon-small aui-iconfont-refresh\">update server status</span></button>`;
                        }
                    })
                }
            ],
            deleteConfirmationCallback: function (model) {

                AJS.dialog2("#delete-confirmation-dialog").show();
                AJS.$("#delete-confirmation-dialog--heading").text(AJS.I18n.getText("global-administration-delete-dialog.label", model.squashServerNameInJira));
                AJS.$("#delete-server-dialog-submit-button").prop("disabled", false);

                AJS.$.ajax({
                    url: baseUrl + "/rest/Xsquash-admin/1.0/project-config/server/" + model.id,
                    contentType: "application/json",
                }).fail(function (XMLHttpRequest, textStatus, errorThrown) {
                    var message;
                    if (XMLHttpRequest.responseText.length !== 0) {
                        message = XMLHttpRequest.responseText;
                    }
                    AJS.$("#delete-server-dialog-submit-button").prop("disabled", true);
                    AJS.$("#delete-server-error-message").addClass("aui-message aui-message-error").show();
                    AJS.$("#delete-server-error-message p").text(message);

                });


                return new Promise(function (resolve, reject) {
                    AJS.$("#delete-server-dialog-submit-button").on('click', function (e) {
                        e.preventDefault();
                        e.stopPropagation();
                        resolve();
                        AJS.dialog2("#delete-confirmation-dialog").hide();
                        var deleteServerSucessFlag = AJS.flag({
                            type: 'success',
                            close: 'auto',
                            body: AJS.I18n.getText("global-administration.delete-server.success.label")
                        });

                    });
                    AJS.$(".aui-close-button, #warning-dialog-cancel").on('click', function (e) {
                        e.preventDefault();
                        e.stopPropagation();
                        reject();
                        AJS.$("#delete-server-error-message").hide();
                        AJS.dialog2("#delete-confirmation-dialog").hide();
                    });

                });
            }
        });
        rt.bind(AJS.RestfulTable.Events.ROW_INITIALIZED, function (row) {
            checkSquashServerStatus(row.model.id);
        });

    JIRA.Dialogs.xsquashServerConfig = new JIRA.Dialog({
        id: "xsquash-server-config-dialog",
        trigger: ".add-squash-server-link",
        ajaxOptions: JIRA.Dialogs.getDefaultAjaxOptions
    });

    JIRA.bind(JIRA.Events.NEW_CONTENT_ADDED, function (e, context, reason) {
        var $context = AJS.$(context);
        if (reason === JIRA.CONTENT_ADDED_REASON.dialogReady) {

            var button = AJS.$("#saveButton");
            button.prop("disabled", true);

            AJS.$("input.text").change(function () {
                button.prop("disabled", false);
            });

            $context.find("#squash-server-form").submit(function (e) {
                e.preventDefault();
                var squashServerUUID = $context.find("#squashServerUUID").attr("value");
                var squashServerNameInJira = $context.find("#serverNameInJira").attr("value");
                var squashURL = $context.find("#squashURL").attr("value");
                var serverName = $context.find("#serverName").attr("value");
                var login = $context.find("#login").attr("value");
                var password = $context.find("#password").attr("value");
                var token = $context.find("#token").attr("value");
                var tokenAuthSelected = $context.find("#token-auth").attr("checked");

                if (!tokenAuthSelected) {
                    if (squashServerNameInJira.trim() !== ""
                        && squashURL.trim() !== ""
                        && serverName.trim() !== ""
                        && login.trim() !== ""
                        && password.trim() !== "") {
                        addOrUpdateServerConfig(squashServerUUID, squashServerNameInJira, squashURL, serverName, login, password, token, rt)
                    } else {
                        $context.find("#result-message").removeClass("aui-message aui-message-confirmation")
                        $context.find("#result-message").addClass("aui-message aui-message-error");
                        $context.find("#result-message p").text(AJS.I18n.getText("global-administration.save-settings.missing-data.label"));
                    }
                } else {
                    if (squashServerNameInJira.trim() !== ""
                        && squashURL.trim() !== ""
                        && serverName.trim() !== ""
                        && token.trim() !== "") {
                        addOrUpdateServerConfig(squashServerUUID, squashServerNameInJira, squashURL, serverName, login, password, token, rt)
                    } else {
                        $context.find("#result-message").removeClass("aui-message aui-message-confirmation")
                        $context.find("#result-message").addClass("aui-message aui-message-error");
                        $context.find("#result-message p").text(AJS.I18n.getText("global-administration.save-settings.missing-data.label"));
                    }
                }
            });

            $context.find("#closeButton").click(function (e) {
                e.preventDefault();
                JIRA.Dialogs.xsquashServerConfig.hide();
            });

        }
    });
});

function inferAuthMode(model) {
    return model.get("token") ? AJS.I18n.getText("global-administration-dialog.auth-mode.token.label") :  AJS.I18n.getText("global-administration-dialog.auth-mode.basic.label");
}

function addOrUpdateServerConfig(squashServerUUID, squashServerNameInJira, squashURL, serverName, login, password, token, rt) {
    var url = squashURL[squashURL.length - 1] === "/" ? squashURL.substring(0, squashURL.length - 1) : squashURL;
    var squashServerConfig = {
        id: squashServerUUID,
        squashServerNameInJira: squashServerNameInJira,
        squashURL: url,
        jiraServerNameInSquash: serverName,
        login: login,
        password: password,
        token: token,
    };

    if (squashServerUUID) {
        updateServerConfig(url, squashServerConfig, rt)
    } else {
        addServerConfig(url, squashServerConfig, rt)
    }

}

function addServerConfig(url, squashServerConfig, rt) {
    AJS.$.ajax({
        url: baseUrl + "/rest/Xsquash-admin/1.0/server-config",
        type: "POST",
        contentType: "application/json",
        data: JSON.stringify(squashServerConfig),
        processData: false
    }).done(function (row) {
        JIRA.Dialogs.xsquashServerConfig.hide();
        var myFlag = AJS.flag({
            type: 'success',
            close: 'auto',
            body: AJS.I18n.getText("global-administration.save-settings.success.label")
        });
        rt.$tbody.empty();
        rt.fetchInitialResources();

    }).fail(function (XMLHttpRequest, textStatus, errorThrown) {
        var message = AJS.I18n.getText("global-administration.save-settings.error.generic.label");
        if (XMLHttpRequest.responseText.length !== 0) {
            message = XMLHttpRequest.responseText;
        }
        AJS.$("#result-message").removeClass("aui-message aui-message-confirmation").addClass("aui-message aui-message-error");
        AJS.$("#result-message p").text(message);
    });

}

function updateServerConfig(url, squashServerConfig, rt) {
    AJS.$.ajax({
        url: baseUrl + "/rest/Xsquash-admin/1.0/server-config/" + squashServerConfig.id,
        type: "PUT",
        contentType: "application/json",
        data: JSON.stringify(squashServerConfig),
        processData: false
    }).done(function (row) {
        JIRA.Dialogs.xsquashServerConfig.hide();
        var myFlag = AJS.flag({
            type: 'success',
            close: 'auto',
            body: AJS.I18n.getText("global-administration.save-settings.success.label")
        });

        rt.$tbody.empty();
        rt.fetchInitialResources();

    }).fail(function (XMLHttpRequest, textStatus, errorThrown) {
        var message = AJS.I18n.getText("global-administration.save-settings.error.generic.label");
        if (XMLHttpRequest.responseText.length !== 0) {
            message = XMLHttpRequest.responseText;
        }
        AJS.$("#result-message").removeClass("aui-message aui-message-confirmation").addClass("aui-message aui-message-error");
        AJS.$("#result-message p").text(message);
    });


}

function checkSquashServerStatus(id) {
    AJS.$(`.spinner-${id}`).show();
    AJS.$(`#${id}`).removeClass("server-on").removeClass("server-off");
    AJS.$.ajax({
        url: baseUrl + "/rest/Xsquash-admin/1.0/server-config/status/" + id,
        type: "GET",
        timeout: 3000
    }).done(function (data) {
        var message = AJS.I18n.getText("global-administration.save-settings.success.label");
        AJS.$(`.spinner-${id}`).hide();
        AJS.$(`#${id}`).addClass("server-on");


    }).fail(function (XMLHttpRequest, textStatus, errorThrown) {
        var message = AJS.I18n.getText("global-administration.save-settings.error.generic.label");
        if (XMLHttpRequest.responseText.length !== 0) {
            message = XMLHttpRequest.responseText;
        }
        AJS.$(`.spinner-${id}`).hide();
        AJS.$(`#${id}`).addClass("server-off");

    });
}





