/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.plugin.jira.Xsquash.web.tabpanels;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueTabPanel;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanel;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.squashtest.plugin.jira.Xsquash.domain.model.jira.ProjectConfig;
import org.squashtest.plugin.jira.Xsquash.domain.model.squash.SquashTestCaseModel;
import org.squashtest.plugin.jira.Xsquash.exception.ProjectConfigException;
import org.squashtest.plugin.jira.Xsquash.service.SquashProjectConfigService;
import org.squashtest.plugin.jira.Xsquash.service.TestCaseFinder;
import org.squashtest.plugin.jira.Xsquash.web.tabpanels.SquashTestCasesIssueAction;

@Named
public class SquashTestCasesTabPanel
extends AbstractIssueTabPanel
implements IssueTabPanel {
    private final PageBuilderService pageBuilderService;
    private TestCaseFinder testCaseFinder;
    private SquashProjectConfigService pService;

    @Inject
    public SquashTestCasesTabPanel(@ComponentImport PageBuilderService pageBuilderService, TestCaseFinder testCaseFinder, SquashProjectConfigService pService) {
        this.pageBuilderService = pageBuilderService;
        this.testCaseFinder = testCaseFinder;
        this.pService = pService;
    }

    public List<IssueAction> getActions(Issue issue, ApplicationUser applicationUser) {
        this.pageBuilderService.assembler().resources().requireWebResource("org.squashtest.plugin.jira.Xsquash:Xsquash-test-cases-issue-tab-panel-resources");
        this.pageBuilderService.assembler().resources().requireWebResource("org.squashtest.plugin.jira.Xsquash:Xsquash-resources");
        List<SquashTestCaseModel> testCases = this.testCaseFinder.getTestCasesFromSquash(issue);
        ArrayList<IssueAction> squashActions = new ArrayList<IssueAction>();
        squashActions.add((IssueAction)new SquashTestCasesIssueAction(this.descriptor, testCases));
        return squashActions;
    }

    public boolean showPanel(Issue issue, ApplicationUser applicationUser) {
        String projectKey = Objects.requireNonNull(issue.getProjectObject()).getKey();
        ProjectConfig projectConfig = null;
        try {
            projectConfig = this.pService.getSquashProjectConfigByProjectKey(projectKey);
        }
        catch (ProjectConfigException ex) {
            return false;
        }
        assert (projectConfig != null);
        return projectConfig.isActivated();
    }
}

