/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.plugin.jira.Xsquash.web.tabpanels;

import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.squashtest.plugin.jira.Xsquash.domain.model.squash.SquashTestCaseModel;
import org.squashtest.plugin.jira.Xsquash.web.tabpanels.SquashExecutionStatus;

public class SquashTestCasesIssueAction
extends AbstractIssueAction {
    List<SquashTestCaseModel> testCaseList;

    SquashTestCasesIssueAction(IssueTabPanelModuleDescriptor issueTabPanelModuleDescriptor, List<SquashTestCaseModel> testCaseList) {
        super(issueTabPanelModuleDescriptor);
        this.testCaseList = testCaseList;
    }

    public Date getTimePerformed() {
        return null;
    }

    protected void populateVelocityParams(Map params) {
        params.put("elementList", this.testCaseList);
        params.put("hasAutomationStatus", this.hasAutomationStatus());
        params.put("automationStatusList", this.retrieveAllAutomationStatus());
        params.put("excutionStatusMap", this.getExecutionStatusHashMap());
        params.put("testCaseStatusMap", this.getTestCaseStatusHashMap());
        params.put("importanceMap", this.getImportanceHashMap());
    }

    private boolean hasAutomationStatus() {
        return this.testCaseList.stream().anyMatch(testCase -> testCase.getAutomationStatus() != null && !testCase.getAutomationStatus().isEmpty());
    }

    private List<String> retrieveAllAutomationStatus() {
        return Arrays.asList("AUTOMATED", "AUTOMATION_IN_PROGRESS", "READY_TO_TRANSMIT", "REJECTED", "SUSPENDED", "TRANSMITTED", "WORK_IN_PROGRESS");
    }

    private Map<String, Integer> getExecutionStatusHashMap() {
        HashMap<String, Integer> executionStatusMap = new HashMap<String, Integer>();
        for (SquashExecutionStatus status : SquashExecutionStatus.values()) {
            executionStatusMap.put(status.name(), status.getValue());
        }
        return executionStatusMap;
    }

    private Map<String, Integer> getImportanceHashMap() {
        HashMap<String, Integer> importanceMap = new HashMap<String, Integer>();
        importanceMap.put("LOW", 1);
        importanceMap.put("MEDIUM", 2);
        importanceMap.put("HIGH", 3);
        importanceMap.put("VERY_HIGH", 4);
        return importanceMap;
    }

    private Map<String, Integer> getTestCaseStatusHashMap() {
        HashMap<String, Integer> testCaseStatusMap = new HashMap<String, Integer>();
        testCaseStatusMap.put("WORK_IN_PROGRESS", 1);
        testCaseStatusMap.put("UNDER_REVIEW", 2);
        testCaseStatusMap.put("APPROVED", 3);
        testCaseStatusMap.put("OBSOLETE", 4);
        testCaseStatusMap.put("TO_BE_UPDATED", 5);
        return testCaseStatusMap;
    }
}

