/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.plugin.jira.Xsquash.web.tabpanels;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueTabPanel;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanel;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.squashtest.plugin.jira.Xsquash.domain.model.jira.ProjectConfig;
import org.squashtest.plugin.jira.Xsquash.domain.model.squash.SquashExecutionStepModel;
import org.squashtest.plugin.jira.Xsquash.domain.model.squash.SquashIterationTestPlanItemModel;
import org.squashtest.plugin.jira.Xsquash.domain.model.squash.SquashTestCaseModel;
import org.squashtest.plugin.jira.Xsquash.exception.ProjectConfigException;
import org.squashtest.plugin.jira.Xsquash.service.IterationTestPlanItemFinder;
import org.squashtest.plugin.jira.Xsquash.service.LicenseService;
import org.squashtest.plugin.jira.Xsquash.service.SquashProjectConfigService;
import org.squashtest.plugin.jira.Xsquash.service.TestCaseFinder;
import org.squashtest.plugin.jira.Xsquash.web.tabpanels.SquashExecutionsIssueAction;

@Named
public class SquashExecutionsTabPanel
extends AbstractIssueTabPanel
implements IssueTabPanel {
    private final PageBuilderService pageBuilderService;
    private IterationTestPlanItemFinder iterationTestPlanItemFinder;
    private TestCaseFinder testCaseFinder;
    private LicenseService licenseService;
    private SquashProjectConfigService pService;

    @Inject
    public SquashExecutionsTabPanel(@ComponentImport PageBuilderService pageBuilderService, IterationTestPlanItemFinder iterationTestPlanItemFinder, TestCaseFinder testCaseFinder, LicenseService licenseService, SquashProjectConfigService pService) {
        this.pageBuilderService = pageBuilderService;
        this.iterationTestPlanItemFinder = iterationTestPlanItemFinder;
        this.licenseService = licenseService;
        this.pService = pService;
        this.testCaseFinder = testCaseFinder;
    }

    public List<IssueAction> getActions(Issue issue, ApplicationUser applicationUser) {
        this.pageBuilderService.assembler().resources().requireWebResource("org.squashtest.plugin.jira.Xsquash:Xsquash-executions-issue-tab-panel-resources");
        this.pageBuilderService.assembler().resources().requireWebResource("org.squashtest.plugin.jira.Xsquash:Xsquash-resources");
        List<SquashTestCaseModel> testCases = Optional.ofNullable(this.testCaseFinder.getTestCasesFromSquash(issue)).orElse(Collections.emptyList());
        List<SquashIterationTestPlanItemModel> result = Optional.ofNullable(this.iterationTestPlanItemFinder.getIterationTestPlanItemFromSquash(issue)).orElse(Collections.emptyList());
        if (!result.isEmpty() && !testCases.isEmpty()) {
            this.populateExecutionSteps(result, testCases);
        }
        return List.of(new SquashExecutionsIssueAction(this.descriptor, result, this.checkIfLicenseIsValid(issue)));
    }

    private void populateExecutionSteps(List<SquashIterationTestPlanItemModel> result, List<SquashTestCaseModel> testCases) {
        Map testCaseMap = testCases.stream().collect(Collectors.toMap(SquashTestCaseModel::getId, Function.identity()));
        result.forEach(itpi -> {
            SquashTestCaseModel testCase = (SquashTestCaseModel)testCaseMap.get(itpi.getReferencedTestCase().getId());
            if (testCase != null) {
                itpi.getExecutions().forEach(execution -> execution.getExecutionSteps().forEach(executionStep -> this.updateExecutionStep((SquashExecutionStepModel)executionStep, testCase)));
            }
        });
    }

    private void updateExecutionStep(SquashExecutionStepModel executionStep, SquashTestCaseModel testCase) {
        testCase.getSteps().stream().filter(step -> step.getId().equals(executionStep.getReferencedTestStepId())).findFirst().ifPresent(step -> {
            executionStep.setAction(step.getAction());
            executionStep.setExpectedResult(step.getResult());
        });
    }

    public boolean showPanel(Issue issue, ApplicationUser applicationUser) {
        String projectKey = Objects.requireNonNull(issue.getProjectObject()).getKey();
        ProjectConfig projectConfig = null;
        try {
            projectConfig = this.pService.getSquashProjectConfigByProjectKey(projectKey);
        }
        catch (ProjectConfigException ex) {
            return false;
        }
        assert (projectConfig != null);
        return projectConfig.isActivated();
    }

    public boolean checkIfLicenseIsValid(Issue issue) {
        String projectKey = Objects.requireNonNull(issue.getProjectObject()).getKey();
        return this.licenseService.isValidLicenseForXsquash(projectKey);
    }
}

