/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.plugin.jira.Xsquash.web.tabpanels;

import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.squashtest.plugin.jira.Xsquash.domain.model.squash.SquashExecutionModel;
import org.squashtest.plugin.jira.Xsquash.domain.model.squash.SquashExecutionStepModel;
import org.squashtest.plugin.jira.Xsquash.domain.model.squash.SquashIterationTestPlanItemModel;
import org.squashtest.plugin.jira.Xsquash.web.tabpanels.SquashExecutionStatus;

public class SquashExecutionsIssueAction
extends AbstractIssueAction {
    List<SquashIterationTestPlanItemModel> executionsList;
    boolean isLicenseValid;
    private static final String HENIX_PRICING_URL = "https://squashtest.com/pricing?utm_source=Appli_squash&utm_medium=link";
    private static final String CONTACT_URL = "https://www.squashtest.com/contact?utm_source=Appli_squash&utm_medium=link";

    public SquashExecutionsIssueAction(IssueTabPanelModuleDescriptor descriptor, List<SquashIterationTestPlanItemModel> executionsList, boolean isLicenseValid) {
        super(descriptor);
        this.executionsList = executionsList;
        this.isLicenseValid = isLicenseValid;
    }

    public Date getTimePerformed() {
        return null;
    }

    protected void populateVelocityParams(Map map) {
        map.put("executionList", this.executionsList);
        map.put("hasDataset", this.hasDataset());
        map.put("itpiHasExecutionStepCommentsMap", this.itpiHasExecutionStepCommentsMap());
        map.put("isLicenseValid", this.isLicenseValid);
        map.put("henixUrl", HENIX_PRICING_URL);
        map.put("contactUrl", CONTACT_URL);
        map.put("excutionStatusMap", this.getExecutionStatusHashMap());
    }

    private boolean hasDataset() {
        return this.executionsList.stream().anyMatch(execution -> execution.getLastExecution() != null && execution.getLastExecution().getDatasetLabel() != null && !execution.getLastExecution().getDatasetLabel().isEmpty() || execution.getLastExecution() == null && execution.getReferencedDataset() != null && execution.getReferencedDataset().getName() != null && !execution.getReferencedDataset().getName().isEmpty());
    }

    private Map<Long, Boolean> itpiHasExecutionStepCommentsMap() {
        HashMap<Long, Boolean> itpiHasExecutionStepCommentMap = new HashMap<Long, Boolean>();
        for (SquashIterationTestPlanItemModel itpi : this.executionsList) {
            List<SquashExecutionStepModel> steps;
            SquashExecutionModel execution = itpi.getLastExecution();
            boolean hasExecutionStepComment = false;
            if (execution != null && (steps = execution.getExecutionSteps()) != null && !steps.isEmpty()) {
                hasExecutionStepComment = steps.stream().anyMatch(step -> step.getComment() != null && !step.getComment().isEmpty());
            }
            itpiHasExecutionStepCommentMap.put(itpi.getId(), hasExecutionStepComment);
        }
        return itpiHasExecutionStepCommentMap;
    }

    private Map<String, Integer> getExecutionStatusHashMap() {
        HashMap<String, Integer> executionStatusMap = new HashMap<String, Integer>();
        for (SquashExecutionStatus status : SquashExecutionStatus.values()) {
            executionStatusMap.put(status.name(), status.getValue());
        }
        return executionStatusMap;
    }
}

