/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.plugin.jira.Xsquash.web.controller;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;
import org.squashtest.plugin.jira.Xsquash.domain.model.jira.SquashServerConfig;
import org.squashtest.plugin.jira.Xsquash.service.SquashServerConfigService;
import org.squashtest.plugin.jira.Xsquash.util.AuthenticationModeResolver;
import org.squashtest.plugin.jira.Xsquash.util.SquashRestApiRequestUtil;

@Named
@Path(value="/server-config")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SquashServerConfigController {
    private static final String ERROR_MESSAGE_URI_SYNTAX = "Error in SquashTM URL syntax.";
    private static final String ERROR_MESSAGE_IO = "IO exception during http request to SquashTM.";
    private static final Logger log = Logger.getLogger(SquashServerConfigController.class);
    private final UserManager userManager;
    private final TransactionTemplate transactionTemplate;
    private final I18nResolver i18nResolver;
    private final SquashServerConfigService sqService;

    @Inject
    public SquashServerConfigController(@ComponentImport UserManager userManager, @ComponentImport TransactionTemplate transactionTemplate, @ComponentImport I18nResolver i18nResolver, SquashServerConfigService sqService) {
        this.userManager = userManager;
        this.transactionTemplate = transactionTemplate;
        this.i18nResolver = i18nResolver;
        this.sqService = sqService;
    }

    @GET
    public Response getAllSquashServerConfig(@Context HttpServletRequest request) {
        UserKey userKey = this.userManager.getRemoteUserKey(request);
        if (this.isUserAdmin(userKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return Response.ok((Object)this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                return SquashServerConfigController.this.sqService.getAllSquashServerConfig();
            }
        })).build();
    }

    @GET
    @Path(value="{id}")
    public Response getSquashServerConfigById(@Context HttpServletRequest request, final @PathParam(value="id") String uuid) {
        UserKey userKey = this.userManager.getRemoteUserKey(request);
        if (this.isUserAdmin(userKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return Response.ok((Object)this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                return SquashServerConfigController.this.sqService.getSquashServerConfigById(uuid);
            }
        })).build();
    }

    @POST
    public Response setSquashServerConfig(final SquashServerConfig sqConfig, @Context HttpServletRequest request, @Context HttpServletResponse response) {
        UserKey userKey = this.userManager.getRemoteUserKey(request);
        if (this.isUserAdmin(userKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (!this.checkSquashAvailability(sqConfig)) {
            String message = this.i18nResolver.getText("global-administration.save-settings.error.squash-connection-fail.label");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build();
        }
        if (this.sqService.isServerNameAlreadyExist(sqConfig.getSquashServerNameInJira())) {
            String message = this.i18nResolver.getText("global-administration.save-settings.error.name-already-used.label", new Serializable[]{sqConfig.getSquashServerNameInJira()});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build();
        }
        return Response.ok((Object)this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                return SquashServerConfigController.this.sqService.saveSquashServerConfig(sqConfig, true);
            }
        })).build();
    }

    @PUT
    @Path(value="{id}")
    public Response updateSquashServerConfig(@PathParam(value="id") String uuid, final SquashServerConfig sqConfig, @Context HttpServletRequest request, @Context HttpServletResponse response) {
        UserKey userKey = this.userManager.getRemoteUserKey(request);
        if (this.isUserAdmin(userKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (!this.checkSquashAvailability(sqConfig)) {
            String message = this.i18nResolver.getText("global-administration.save-settings.error.squash-connection-fail.label");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build();
        }
        return Response.ok((Object)this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                return SquashServerConfigController.this.sqService.updateSquashServerConfig(sqConfig, true);
            }
        })).build();
    }

    @GET
    @Path(value="/status/{id}")
    public Response checkIfSquashServerIsActive(@Context HttpServletRequest request, @PathParam(value="id") String uuid) {
        SquashServerConfig serverConfig = this.sqService.getSquashServerConfigById(uuid);
        if (this.checkSquashAvailability(serverConfig)) {
            return Response.ok((Object)true).build();
        }
        return Response.status((int)500).entity((Object)false).build();
    }

    @DELETE
    @Path(value="/{id}")
    public Response deleteSquashServerConfig(@Context HttpServletRequest request, @PathParam(value="id") String uuid) {
        UserKey userKey = this.userManager.getRemoteUserKey(request);
        if (this.isUserAdmin(userKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.transactionTemplate.execute(() -> {
            this.sqService.deleteSquashServerConfig(uuid);
            return null;
        });
        return Response.noContent().build();
    }

    private boolean isUserAdmin(UserKey userKey) {
        return userKey == null || !this.userManager.isSystemAdmin(userKey);
    }

    private boolean checkSquashAvailability(SquashServerConfig config) {
        try {
            CloseableHttpResponse response;
            HttpClientContext httpClientContext = SquashRestApiRequestUtil.createHttpClientContext(new URI(config.getSquashURL()), config);
            CloseableHttpClient httpClient = HttpClients.createSystem();
            HttpGet httpGet = new HttpGet(config.getSquashURL() + "/api/rest/latest/docs/api-documentation.html");
            if (AuthenticationModeResolver.isTokenAuth(config)) {
                httpGet.setHeader("Authorization", "Bearer " + config.getToken());
            }
            if ((response = httpClient.execute((HttpUriRequest)httpGet, (HttpContext)httpClientContext)).getStatusLine().getStatusCode() == 200) {
                return true;
            }
        }
        catch (URISyntaxException e) {
            log.error((Object)ERROR_MESSAGE_URI_SYNTAX, (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)ERROR_MESSAGE_IO, (Throwable)e);
        }
        catch (RuntimeException e) {
            log.error((Object)e);
        }
        return false;
    }
}

