/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.plugin.jira.Xsquash.web.controller;

import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.squashtest.plugin.jira.Xsquash.domain.model.jira.ProjectConfig;
import org.squashtest.plugin.jira.Xsquash.service.SquashProjectConfigService;

@Named
@Path(value="/project-config")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SquashProjectConfigController {
    private static final Logger log = Logger.getLogger(SquashProjectConfigController.class);
    private final TransactionTemplate transactionTemplate;
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final I18nResolver i18nResolver;
    private SquashProjectConfigService pService;
    private static final String PROJECT_ADMIN_PERMISSION_KEY = "ADMINISTER_PROJECTS";
    private static final String PROJECT_VIEWER_PERMISSION_KEY = "BROWSE_PROJECTS";

    @Inject
    public SquashProjectConfigController(@ComponentImport TransactionTemplate transactionTemplate, @ComponentImport PermissionManager permissionManager, @ComponentImport ProjectManager projectManager, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport I18nResolver i18nResolver, SquashProjectConfigService pService) {
        this.transactionTemplate = transactionTemplate;
        this.permissionManager = permissionManager;
        this.projectManager = projectManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.i18nResolver = i18nResolver;
        this.pService = pService;
    }

    @GET
    @Path(value="/{projectKey}")
    public Response getProjectConfig(@Context HttpServletRequest request, @PathParam(value="projectKey") String projectKey) {
        if (!this.isUserCanViewProject(projectKey)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Optional optional = (Optional)this.transactionTemplate.execute(() -> this.pService.getOptionalSquashProjectConfigByProjectKey(projectKey));
        if (optional.isPresent()) {
            return Response.ok(optional.get()).build();
        }
        return Response.noContent().build();
    }

    @GET
    @Path(value="server/{serverId}")
    public Response getJiraPojectUsingGivenSquashServer(@Context HttpServletRequest request, @PathParam(value="serverId") String serverId) {
        List<ProjectConfig> listProject = this.pService.getAllProjectsUsingGivenServerById(serverId);
        if (listProject.size() > 0) {
            String activeProj = listProject.stream().map(ProjectConfig::getProjectKey).collect(Collectors.joining(","));
            String message = this.i18nResolver.getText("global-administration.delete-server.error.server-use-in-project.label", new Serializable[]{serverId, activeProj});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)message).build();
        }
        return Response.ok((Object)true).build();
    }

    @PUT
    public Response putProjectConfig(ProjectConfig projectConfig, @Context HttpServletRequest request, @Context HttpServletResponse response) {
        if (!this.isUserProjectAdmin(projectConfig.getProjectKey())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (this.pService.isProjectConfigIsAlreadySet(projectConfig.getProjectKey()).booleanValue()) {
            return Response.ok((Object)this.transactionTemplate.execute(() -> this.pService.updateSquashProjectConfig(projectConfig))).build();
        }
        return Response.ok((Object)this.transactionTemplate.execute(() -> this.pService.saveSquashProjectConfig(projectConfig))).build();
    }

    private boolean isUserCanViewProject(String projectKey) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        return user != null && this.permissionManager.hasPermission(new ProjectPermissionKey(PROJECT_VIEWER_PERMISSION_KEY), this.projectManager.getProjectByCurrentKey(projectKey), user);
    }

    private boolean isUserProjectAdmin(String projectKey) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        return user != null && this.permissionManager.hasPermission(new ProjectPermissionKey(PROJECT_ADMIN_PERMISSION_KEY), this.projectManager.getProjectByCurrentKey(projectKey), user);
    }
}

