/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.plugin.jira.Xsquash.web;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.webfragment.conditions.AbstractWebCondition;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import org.squashtest.plugin.jira.Xsquash.domain.model.jira.ProjectConfig;
import org.squashtest.plugin.jira.Xsquash.service.SquashProjectConfigService;

public class ActivePluginCondition
extends AbstractWebCondition {
    @Inject
    private SquashProjectConfigService pService;
    private static final String XSQUASH_PROJECT_CONFIG_KEY = "xsquash-project-configuration";

    @Inject
    public ActivePluginCondition(SquashProjectConfigService pService) {
        this.pService = pService;
    }

    public boolean shouldDisplay(ApplicationUser applicationUser, JiraHelper jiraHelper) {
        Map params = jiraHelper.getContextParams();
        Issue issue = (Issue)params.get("issue");
        String projectKey = Objects.requireNonNull(issue.getProjectObject()).getKey();
        ProjectConfig projectConfig = this.pService.getSquashProjectConfigByProjectKey(projectKey);
        if (projectConfig != null) {
            return projectConfig.isActivated();
        }
        return false;
    }
}

