/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.plugin.jira.Xsquash.util;

import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.squashtest.plugin.jira.Xsquash.domain.model.jira.SquashServerConfig;
import org.squashtest.plugin.jira.Xsquash.util.AuthenticationModeResolver;

public class SquashRestApiRequestUtil {
    private static final Logger log = Logger.getLogger(SquashRestApiRequestUtil.class);
    private static final String HTTP_ACCEPT_HEADER_JSON_VALUE = "application/json";
    private static final String ERROR_MESSAGE_IO = "IO exception during http request to SquashTM";

    public static HttpClientContext createHttpClientContext(URI squashURI, SquashServerConfig config) {
        if (AuthenticationModeResolver.isTokenAuth(config)) {
            return SquashRestApiRequestUtil.createHttpClientContextTokenAuth(squashURI, config);
        }
        if (AuthenticationModeResolver.isBasicAuth(config)) {
            return SquashRestApiRequestUtil.createHttpClientContextBasicAuth(squashURI, config);
        }
        throw new IllegalArgumentException("Wrong credentials, please provide either token or login/password.");
    }

    public static HttpClientContext createHttpClientContextBasicAuth(URI squashURI, SquashServerConfig config) {
        HttpClientContext context = HttpClientContext.create();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(squashURI.getHost(), squashURI.getPort()), (Credentials)new UsernamePasswordCredentials(config.getLogin(), config.getPassword()));
        context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        return context;
    }

    public static HttpClientContext createHttpClientContextTokenAuth(URI squashURI, SquashServerConfig config) {
        HttpClientContext context = HttpClientContext.create();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(squashURI.getHost(), squashURI.getPort()), (Credentials)new UsernamePasswordCredentials("", config.getToken()));
        context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        return context;
    }

    public static String makeRestCallToSquash(URI squashURI, HttpClientContext context, SquashServerConfig config) {
        HttpGet httpGet = new HttpGet(squashURI);
        httpGet.setHeader("Accept", HTTP_ACCEPT_HEADER_JSON_VALUE);
        if (config.getToken() != null && !config.getToken().isEmpty()) {
            httpGet.setHeader("Authorization", "Bearer " + config.getToken());
        }
        String jsonResponse = "";
        try (CloseableHttpClient httpClient = HttpClients.createSystem();
             CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet, (HttpContext)context);){
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                jsonResponse = EntityUtils.toString((HttpEntity)entity);
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException("Issue during HTTP request. Response status code: " + response.getStatusLine().getStatusCode());
            }
        }
        catch (IOException e) {
            log.error((Object)ERROR_MESSAGE_IO, (Throwable)e);
        }
        catch (RuntimeException e) {
            log.error((Object)e);
        }
        return jsonResponse;
    }

    /*
     * Exception decompiling
     */
    public static Optional<ImageData> downloadImageAsBase64(URI squashURI, SquashServerConfig config, HttpClientContext context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 28[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class ImageData {
        private final String base64;
        private final String mimeType;

        public ImageData(String base64, String mimeType) {
            this.base64 = base64;
            this.mimeType = mimeType;
        }

        public String getBase64() {
            return this.base64;
        }

        public String getMimeType() {
            return this.mimeType;
        }
    }
}

