/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.plugin.jira.Xsquash.servlet;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.squashtest.plugin.jira.Xsquash.domain.model.jira.SquashServerConfig;
import org.squashtest.plugin.jira.Xsquash.service.SquashServerConfigService;

@Named
public class SquashServerFormServlet
extends HttpServlet {
    private static final long serialVersionUID = -5741187512097084248L;
    private final UserManager userManager;
    private final TemplateRenderer templateRenderer;
    private final PageBuilderService pageBuilderService;
    private static final String XSQUASH_GLOBAL_CONFIG_KEY = "xsquash-global-configuration";
    @Inject
    private SquashServerConfigService sqService;

    @Inject
    public SquashServerFormServlet(@ComponentImport UserManager userManager, @ComponentImport TemplateRenderer templateRenderer, @ComponentImport PageBuilderService pageBuilderService) {
        this.userManager = userManager;
        this.templateRenderer = templateRenderer;
        this.pageBuilderService = pageBuilderService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String username = this.userManager.getRemoteUsername(req);
        if (username == null || !this.userManager.isSystemAdmin(username)) {
            resp.sendError(403);
            return;
        }
        this.pageBuilderService.assembler().resources().requireWebResource("org.squashtest.plugin.jira.Xsquash:Xsquash-admin-resources");
        resp.setContentType("text/html;charset=utf-8");
        if (req.getParameter("uuid") != null) {
            SquashServerConfig serverConfig = this.sqService.getSquashServerConfigById(req.getParameter("uuid"));
            if (serverConfig != null) {
                HashMap<String, SquashServerConfig> context = new HashMap<String, SquashServerConfig>();
                context.put("serverConfig", serverConfig);
                this.templateRenderer.render("templates/admin/update-squash-server-form.vm", context, (Writer)resp.getWriter());
            } else {
                this.templateRenderer.render("templates/admin/create-squash-server-form.vm", (Writer)resp.getWriter());
            }
        } else {
            this.templateRenderer.render("templates/admin/create-squash-server-form.vm", (Writer)resp.getWriter());
        }
    }
}

