/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.plugin.jira.Xsquash.servlet;

import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.squashtest.plugin.jira.Xsquash.domain.model.jira.SquashServerConfig;
import org.squashtest.plugin.jira.Xsquash.service.SquashServerConfigService;

@Named
public class ProjectAdministrationServlet
extends HttpServlet {
    private static final long serialVersionUID = -5741187512097084163L;
    private final TemplateRenderer templateRenderer;
    private final PageBuilderService pageBuilderService;
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private static final String PROJECT_ADMIN_PERMISSION_KEY = "ADMINISTER_PROJECTS";
    private final SquashServerConfigService sqService;

    @Inject
    public ProjectAdministrationServlet(@ComponentImport TemplateRenderer templateRenderer, @ComponentImport PageBuilderService pageBuilderService, @ComponentImport PermissionManager permissionManager, @ComponentImport ProjectManager projectManager, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, SquashServerConfigService sqService) {
        this.templateRenderer = templateRenderer;
        this.pageBuilderService = pageBuilderService;
        this.permissionManager = permissionManager;
        this.projectManager = projectManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.sqService = sqService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        String projectKey = req.getParameter("key");
        if (user == null || !this.permissionManager.hasPermission(new ProjectPermissionKey(PROJECT_ADMIN_PERMISSION_KEY), this.projectManager.getProjectByCurrentKey(projectKey), user)) {
            resp.sendError(403);
            return;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("projectKey", projectKey);
        context.put("projectName", req.getParameter("name"));
        List<SquashServerConfig> squashServerConfigList = this.sqService.getAllSquashServerConfig();
        context.put("squashServerConfigList", squashServerConfigList);
        this.pageBuilderService.assembler().resources().requireWebResource("org.squashtest.plugin.jira.Xsquash:Xsquash-project-admin-resource");
        resp.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render("templates/admin/project-admin.vm", context, (Writer)resp.getWriter());
    }
}

