/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.plugin.jira.Xsquash.service.impl;

import com.atlassian.jira.issue.Issue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.squashtest.plugin.jira.Xsquash.domain.dao.TestCaseDao;
import org.squashtest.plugin.jira.Xsquash.domain.model.jira.SquashServerConfig;
import org.squashtest.plugin.jira.Xsquash.domain.model.squash.SquashAttachmentModel;
import org.squashtest.plugin.jira.Xsquash.domain.model.squash.SquashDatasetModel;
import org.squashtest.plugin.jira.Xsquash.domain.model.squash.SquashExecutionModel;
import org.squashtest.plugin.jira.Xsquash.domain.model.squash.SquashIterationTestPlanItemModel;
import org.squashtest.plugin.jira.Xsquash.domain.model.squash.SquashParameterModel;
import org.squashtest.plugin.jira.Xsquash.domain.model.squash.SquashRequirementStub;
import org.squashtest.plugin.jira.Xsquash.domain.model.squash.SquashTestCaseModel;
import org.squashtest.plugin.jira.Xsquash.domain.model.squash.SquashTestCaseStub;
import org.squashtest.plugin.jira.Xsquash.service.SquashAttachmentManagementService;
import org.squashtest.plugin.jira.Xsquash.service.SquashServerConfigService;
import org.squashtest.plugin.jira.Xsquash.service.TestCaseFinder;
import org.squashtest.plugin.jira.Xsquash.service.impl.IterationTestPlanItemFinderImpl;

@Named(value="TestCaseFinder")
public class TestCaseFinderImpl
implements TestCaseFinder {
    private static final Logger log = Logger.getLogger(TestCaseFinderImpl.class);
    private static final String URL_EXTENDER_TEST_CASE = "/test-case-workspace/test-case/%s";
    private static final String SYNCHRONIZED_REQUESTS_JSON_EMBEDDED_NODE = "_embedded";
    private static final String SYNCHRONIZED_REQUESTS_JSON_REQUIREMENTS_NODE = "requirements";
    private static final String SYNCHRONIZED_REQUESTS_JSON_HIGH_LEVEL_REQUIREMENTS_NODE = "high-level-requirements";
    private static final String SYNCHRONIZED_REQUESTS_JSON_PAGE_NODE = "page";
    private static final String SYNCHRONIZED_REQUESTS_JSON_TOTAL_PAGES_NODE = "totalPages";
    private static final String ERROR_MESSAGE_JSON_PARSING = "JSON parsing exception ";
    private static final String ERROR_MESSAGE_JSON_MAPPING = "JSON mapping exception ";
    private static final String ERROR_MESSAGE_IO = "IO exception ";
    private static final String ERROR_MESSAGE_TEST_CASE_SEARCH_CONTEXT = "during SquashTM test case search";
    private static final String ERROR_MESSAGE_TEST_CASES_SEARCH_CONTEXT = "during SquashTM test cases search";
    private static ObjectMapper objectMapper = new ObjectMapper();
    private static Map<String, Integer> importanceValueMap;
    private static Comparator<SquashTestCaseModel> squashTestCaseModelComparator;
    @Inject
    private SquashServerConfigService sqService;
    @Inject
    private TestCaseDao testCaseDao;
    @Inject
    private IterationTestPlanItemFinderImpl iterationTestPlanItemFinderImpl;
    @Inject
    private SquashAttachmentManagementService squashAttachmentManagementService;

    @Override
    public List<SquashTestCaseModel> getTestCasesFromSquash(Issue issue) {
        ArrayList<SquashTestCaseModel> result = new ArrayList<SquashTestCaseModel>();
        List<SquashIterationTestPlanItemModel> iterationList = this.iterationTestPlanItemFinderImpl.getIterationTestPlanItemFromSquash(issue);
        Set<SquashTestCaseStub> testCaseIdList = this.findTestCaseIds(issue);
        testCaseIdList.forEach(squashTestCaseStub -> {
            SquashTestCaseModel testCaseModel = this.findTestCase(squashTestCaseStub.getId(), issue.getProjectObject().getKey());
            this.handleAttachments(testCaseModel, issue.getProjectObject().getKey());
            iterationList.stream().filter(itpi -> itpi.getReferencedTestCase() != null && itpi.getReferencedTestCase().getId().equals(testCaseModel.getId())).max(Comparator.comparing(SquashIterationTestPlanItemModel::getLastExecutionDate, Comparator.nullsFirst(Comparator.naturalOrder()))).ifPresent(itpi -> {
                SquashExecutionModel lastExecution;
                if (itpi.getExecutionStatus() != null) {
                    testCaseModel.setExecutionStatus(itpi.getExecutionStatus());
                }
                if ((lastExecution = itpi.getLastExecution()) != null) {
                    testCaseModel.setExecutionURL(lastExecution.getSquashURL());
                }
            });
            result.add(testCaseModel);
        });
        result.sort(squashTestCaseModelComparator);
        return result;
    }

    @Override
    public long findTestCasesNumber(Issue issue) {
        Set<SquashTestCaseStub> testCaseIds = this.findTestCaseIds(issue);
        long testCasesNumber = testCaseIds.size();
        return testCasesNumber;
    }

    private SquashTestCaseModel findTestCase(Long id, String projectKey) {
        SquashTestCaseModel testCaseModel;
        SquashServerConfig squashServerConfig = this.sqService.getSquashServerConfigByJiraProjectKey(projectKey);
        String jsonResponse = this.testCaseDao.findSquashTestCaseByIdAsJson(id, squashServerConfig);
        try {
            testCaseModel = (SquashTestCaseModel)objectMapper.readValue(jsonResponse, SquashTestCaseModel.class);
            testCaseModel.setSquashURL(String.format(squashServerConfig.getSquashURL() + URL_EXTENDER_TEST_CASE, testCaseModel.getId()));
            List<SquashDatasetModel> datasets = testCaseModel.getDatasets();
            if (datasets != null) {
                datasets.forEach(dataset -> {
                    List<SquashParameterModel> parameters = dataset.getParameters();
                    parameters.sort(Comparator.comparing(SquashParameterModel::getName));
                });
            }
        }
        catch (JsonParseException e) {
            log.error((Object)"JSON parsing exception during SquashTM test case search", (Throwable)e);
            throw new RuntimeException("JSON parsing exception during SquashTM test case search", e);
        }
        catch (JsonMappingException e) {
            log.error((Object)"JSON mapping exception during SquashTM test case search", (Throwable)e);
            throw new RuntimeException("JSON mapping exception during SquashTM test case search", e);
        }
        catch (IOException e) {
            log.error((Object)"IO exception during SquashTM test case search", (Throwable)e);
            throw new RuntimeException("IO exception during SquashTM test case search", e);
        }
        return testCaseModel;
    }

    private void handleAttachments(SquashTestCaseModel testCaseModel, String projectKey) {
        SquashServerConfig squashServerConfig = this.sqService.getSquashServerConfigByJiraProjectKey(projectKey);
        testCaseModel.getSteps().forEach(step -> {
            this.processAttachments(step.getAttachments(), squashServerConfig, step::getAction, step::setAction);
            this.processAttachments(step.getAttachments(), squashServerConfig, step::getResult, step::setResult);
        });
        this.processAttachments(testCaseModel.getAttachments(), squashServerConfig, testCaseModel::getDescription, testCaseModel::setDescription);
        this.processAttachments(testCaseModel.getAttachments(), squashServerConfig, testCaseModel::getPrerequisite, testCaseModel::setPrerequisite);
    }

    private void processAttachments(List<SquashAttachmentModel> attachments, SquashServerConfig squashServerConfig, Supplier<String> getter, Consumer<String> setter) {
        if (attachments != null && !attachments.isEmpty() && getter.get() != null) {
            String updatedContent = attachments.stream().reduce(getter.get(), (content, attachment) -> this.squashAttachmentManagementService.replaceAttachmentWithBase64((SquashAttachmentModel)attachment, squashServerConfig, (String)content), (c1, c2) -> c2);
            setter.accept(updatedContent);
        }
    }

    private Set<SquashTestCaseStub> findTestCaseIds(Issue issue) {
        HashSet<SquashTestCaseStub> testCaseIds = new HashSet<SquashTestCaseStub>();
        int totalPages = 0;
        int currentPageNumber = 0;
        do {
            String jsonResponse;
            if (!(jsonResponse = this.testCaseDao.findSynchronizedSquashRequirementsAsJson(issue, Integer.toString(currentPageNumber))).contains(SYNCHRONIZED_REQUESTS_JSON_EMBEDDED_NODE)) continue;
            try {
                JsonNode json = (JsonNode)objectMapper.readValue(jsonResponse, JsonNode.class);
                JsonNode embeddedNode = json.get(SYNCHRONIZED_REQUESTS_JSON_EMBEDDED_NODE);
                JsonNode pageNode = json.get(SYNCHRONIZED_REQUESTS_JSON_PAGE_NODE);
                totalPages = pageNode.get(SYNCHRONIZED_REQUESTS_JSON_TOTAL_PAGES_NODE).asInt();
                JsonNode requirementsNode = Objects.isNull(embeddedNode.get(SYNCHRONIZED_REQUESTS_JSON_REQUIREMENTS_NODE)) ? embeddedNode.get(SYNCHRONIZED_REQUESTS_JSON_HIGH_LEVEL_REQUIREMENTS_NODE) : embeddedNode.get(SYNCHRONIZED_REQUESTS_JSON_REQUIREMENTS_NODE);
                List requirementsList = (List)objectMapper.convertValue((Object)requirementsNode, (TypeReference)new TypeReference<List<SquashRequirementStub>>(){});
                for (SquashRequirementStub requirement : requirementsList) {
                    List verifyingTestCaseStubs = requirement.getCurrentVersion().getTestCaseList().stream().filter(it -> it.getId() != null).collect(Collectors.toList());
                    testCaseIds.addAll(verifyingTestCaseStubs);
                }
            }
            catch (JsonParseException e) {
                log.error((Object)"JSON parsing exception during SquashTM test cases search", (Throwable)e);
                throw new RuntimeException("JSON parsing exception during SquashTM test cases search", e);
            }
            catch (JsonMappingException e) {
                log.error((Object)"JSON mapping exception during SquashTM test cases search", (Throwable)e);
                throw new RuntimeException("JSON mapping exception during SquashTM test cases search", e);
            }
            catch (IOException e) {
                log.error((Object)"IO exception during SquashTM test cases search", (Throwable)e);
                throw new RuntimeException("IO exception during SquashTM test cases search", e);
            }
        } while (++currentPageNumber < totalPages && currentPageNumber != totalPages - 1);
        return testCaseIds;
    }

    private static void configureObjectMapper() {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    private static void initImportanceValueMap() {
        importanceValueMap = new HashMap<String, Integer>();
        importanceValueMap.put("LOW", 0);
        importanceValueMap.put("MEDIUM", 1);
        importanceValueMap.put("HIGH", 2);
        importanceValueMap.put("VERY_HIGH", 3);
    }

    private static void createComparator() {
        Comparator<SquashTestCaseModel> tcImportanceComparator = Comparator.comparingInt(tc -> importanceValueMap.get(tc.getImportance()));
        Comparator<SquashTestCaseModel> tcReferenceComparator = Comparator.comparing(SquashTestCaseModel::getReference);
        Comparator<SquashTestCaseModel> tcNameComparator = Comparator.comparing(SquashTestCaseModel::getName);
        squashTestCaseModelComparator = tcImportanceComparator.reversed().thenComparing(tcReferenceComparator).thenComparing(tcNameComparator);
    }

    static {
        TestCaseFinderImpl.initImportanceValueMap();
        TestCaseFinderImpl.configureObjectMapper();
        TestCaseFinderImpl.createComparator();
    }
}

