/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.plugin.jira.Xsquash.service.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.squashtest.plugin.jira.Xsquash.domain.activeObject.SquashServerConfigActiveObject;
import org.squashtest.plugin.jira.Xsquash.domain.model.jira.ProjectConfig;
import org.squashtest.plugin.jira.Xsquash.domain.model.jira.SquashServerConfig;
import org.squashtest.plugin.jira.Xsquash.service.SquashProjectConfigService;
import org.squashtest.plugin.jira.Xsquash.service.SquashServerConfigService;
import org.squashtest.plugin.jira.Xsquash.util.AuthenticationModeResolver;

@Named
public class SquashServerConfigServiceImpl
implements SquashServerConfigService {
    private final ActiveObjects ao;
    private final SquashProjectConfigService pService;

    @Inject
    public SquashServerConfigServiceImpl(@ComponentImport ActiveObjects ao, SquashProjectConfigService pService) {
        this.ao = ao;
        this.pService = pService;
    }

    @Override
    public List<SquashServerConfig> getAllSquashServerConfig() {
        ArrayList<SquashServerConfig> sqConfigList = new ArrayList<SquashServerConfig>();
        for (SquashServerConfigActiveObject sqConfigAo : (SquashServerConfigActiveObject[])this.ao.find(SquashServerConfigActiveObject.class)) {
            SquashServerConfig config = new SquashServerConfig(String.valueOf(sqConfigAo.getID()), sqConfigAo.getSquashURL(), sqConfigAo.getSquashServerNameInJira(), sqConfigAo.getJiraServerNameInSquash(), sqConfigAo.getLogin(), sqConfigAo.getPassword(), sqConfigAo.getToken());
            sqConfigList.add(config);
        }
        sqConfigList.sort((a, b) -> a.getSquashServerNameInJira().compareToIgnoreCase(b.getSquashServerNameInJira()));
        return sqConfigList;
    }

    @Override
    public SquashServerConfig getSquashServerConfigById(String id) {
        SquashServerConfigActiveObject sqConfigAo = ((SquashServerConfigActiveObject[])this.ao.find(SquashServerConfigActiveObject.class, Query.select().where("ID = ?", new Object[]{Integer.parseInt(id)})))[0];
        return this.buildSquashServerConfig(sqConfigAo);
    }

    @Override
    public SquashServerConfig getSquashServerConfigByJiraProjectKey(String pKey) {
        ProjectConfig projectConfig = this.pService.getSquashProjectConfigByProjectKey(pKey);
        SquashServerConfigActiveObject sqConfigAo = ((SquashServerConfigActiveObject[])this.ao.find(SquashServerConfigActiveObject.class, Query.select().where("ID = ?", new Object[]{Integer.parseInt(projectConfig.getServerUuid())})))[0];
        return this.buildSquashServerConfig(sqConfigAo);
    }

    private SquashServerConfig buildSquashServerConfig(SquashServerConfigActiveObject sqConfigAo) {
        if (sqConfigAo.getToken() != null && !sqConfigAo.getToken().isEmpty()) {
            return new SquashServerConfig(String.valueOf(sqConfigAo.getID()), sqConfigAo.getSquashURL(), sqConfigAo.getSquashServerNameInJira(), sqConfigAo.getJiraServerNameInSquash(), this.decodeGivenPassword(sqConfigAo.getToken()));
        }
        return new SquashServerConfig(String.valueOf(sqConfigAo.getID()), sqConfigAo.getSquashURL(), sqConfigAo.getSquashServerNameInJira(), sqConfigAo.getJiraServerNameInSquash(), sqConfigAo.getLogin(), this.decodeGivenPassword(sqConfigAo.getPassword()));
    }

    @Override
    public SquashServerConfig saveSquashServerConfig(SquashServerConfig config, Boolean encodePassword) {
        SquashServerConfigActiveObject sqConfigAo = (SquashServerConfigActiveObject)this.ao.create(SquashServerConfigActiveObject.class, new DBParam[0]);
        return this.doSaveSquashServerConfig(config, encodePassword, sqConfigAo);
    }

    @Override
    public SquashServerConfig updateSquashServerConfig(SquashServerConfig config, Boolean encodePassword) {
        SquashServerConfigActiveObject sqConfigAo = ((SquashServerConfigActiveObject[])this.ao.find(SquashServerConfigActiveObject.class, Query.select().where("ID = ?", new Object[]{Integer.parseInt(config.getId())})))[0];
        return this.doSaveSquashServerConfig(config, encodePassword, sqConfigAo);
    }

    private SquashServerConfig doSaveSquashServerConfig(SquashServerConfig config, Boolean encodePassword, SquashServerConfigActiveObject sqConfigAo) {
        sqConfigAo.setSquashURL(config.getSquashURL());
        sqConfigAo.setSquashServerNameInJira(config.getSquashServerNameInJira());
        sqConfigAo.setJiraServerNameInSquash(config.getJiraServerNameInSquash());
        if (AuthenticationModeResolver.isBasicAuth(config)) {
            sqConfigAo.setLogin(config.getLogin());
            sqConfigAo.setPassword(Boolean.TRUE.equals(encodePassword) ? this.encodeGivenPassword(config.getPassword()) : config.getPassword());
            sqConfigAo.setToken(null);
        } else if (AuthenticationModeResolver.isTokenAuth(config)) {
            sqConfigAo.setLogin(null);
            sqConfigAo.setPassword(null);
            sqConfigAo.setToken(this.encodeGivenPassword(config.getToken()));
        } else {
            throw new IllegalArgumentException("There is an issue with the authentication mode, please check this is either token auth or basic auth.");
        }
        sqConfigAo.save();
        if (AuthenticationModeResolver.isBasicAuth(config)) {
            return new SquashServerConfig(String.valueOf(sqConfigAo.getID()), sqConfigAo.getSquashURL(), sqConfigAo.getSquashServerNameInJira(), sqConfigAo.getJiraServerNameInSquash(), sqConfigAo.getLogin(), sqConfigAo.getPassword());
        }
        return new SquashServerConfig(String.valueOf(sqConfigAo.getID()), sqConfigAo.getSquashURL(), sqConfigAo.getSquashServerNameInJira(), sqConfigAo.getJiraServerNameInSquash(), sqConfigAo.getToken());
    }

    @Override
    public void deleteSquashServerConfig(String id) {
        this.ao.deleteWithSQL(SquashServerConfigActiveObject.class, "ID = ?", new Object[]{Integer.parseInt(id)});
    }

    @Override
    public boolean isServerNameAlreadyExist(String squashServerName) {
        SquashServerConfigActiveObject[] sqConfigAo = (SquashServerConfigActiveObject[])this.ao.find(SquashServerConfigActiveObject.class, Query.select().where("SQUASH_SERVER_NAME_IN_JIRA = ?", new Object[]{squashServerName}));
        return sqConfigAo.length > 0;
    }

    private String encodeGivenPassword(String password) {
        return Base64.getEncoder().encodeToString(password.getBytes());
    }

    private String decodeGivenPassword(String password) {
        return new String(Base64.getDecoder().decode(password), StandardCharsets.UTF_8);
    }
}

