/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.plugin.jira.Xsquash.service.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.apache.log4j.Logger;
import org.squashtest.plugin.jira.Xsquash.domain.activeObject.ProjectConfigActiveObject;
import org.squashtest.plugin.jira.Xsquash.domain.activeObject.SquashServerConfigActiveObject;
import org.squashtest.plugin.jira.Xsquash.domain.model.jira.ProjectConfig;
import org.squashtest.plugin.jira.Xsquash.exception.ProjectConfigException;
import org.squashtest.plugin.jira.Xsquash.service.SquashProjectConfigService;

@Named
public class SquashProjectConfigServiceImpl
implements SquashProjectConfigService {
    private static final Logger log = Logger.getLogger(SquashProjectConfigServiceImpl.class);
    private final ActiveObjects ao;

    @Inject
    public SquashProjectConfigServiceImpl(@ComponentImport ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public List<ProjectConfig> getAllSquashProjectConfig() {
        ArrayList<ProjectConfig> pConfigList = new ArrayList<ProjectConfig>();
        for (ProjectConfigActiveObject pConfigAo : (ProjectConfigActiveObject[])this.ao.find(ProjectConfigActiveObject.class)) {
            ProjectConfig config = new ProjectConfig(pConfigAo.getProjectKey(), pConfigAo.getServerUuid(), pConfigAo.isActivated(), pConfigAo.getTestCasesTabName(), pConfigAo.getExecutionsTabName());
            pConfigList.add(config);
        }
        return pConfigList;
    }

    @Override
    public ProjectConfig getSquashProjectConfigById(String id) {
        ProjectConfigActiveObject[] pConfigAo = (ProjectConfigActiveObject[])this.ao.find(ProjectConfigActiveObject.class, Query.select().where("ID = ?", new Object[]{Integer.parseInt(id)}));
        if (pConfigAo.length == 0) {
            throw new ProjectConfigException("No configuration for the project " + id);
        }
        return new ProjectConfig(pConfigAo[0].getProjectKey(), pConfigAo[0].getServerUuid(), pConfigAo[0].isActivated(), pConfigAo[0].getTestCasesTabName(), pConfigAo[0].getExecutionsTabName());
    }

    @Override
    public List<ProjectConfig> getAllProjectsUsingGivenServerById(String serverId) {
        ArrayList<ProjectConfig> pConfigList = new ArrayList<ProjectConfig>();
        for (ProjectConfigActiveObject pConfigAo : (ProjectConfigActiveObject[])this.ao.find(ProjectConfigActiveObject.class, Query.select().where("SERVER_UUID = ? AND ACTIVATED = true", new Object[]{serverId}))) {
            ProjectConfig config = new ProjectConfig(pConfigAo.getProjectKey(), pConfigAo.getServerUuid(), pConfigAo.isActivated(), pConfigAo.getTestCasesTabName(), pConfigAo.getExecutionsTabName());
            pConfigList.add(config);
        }
        return pConfigList;
    }

    @Override
    public ProjectConfig getSquashProjectConfigByProjectKey(String pKey) {
        return this.getOptionalSquashProjectConfigByProjectKey(pKey).orElseThrow(() -> new ProjectConfigException("No configuration for the project " + pKey));
    }

    @Override
    public Optional<ProjectConfig> getOptionalSquashProjectConfigByProjectKey(String pKey) {
        ProjectConfigActiveObject[] pConfigAo = (ProjectConfigActiveObject[])this.ao.find(ProjectConfigActiveObject.class, Query.select().where("PROJECT_KEY = ?", new Object[]{pKey}));
        if (pConfigAo.length == 0) {
            return Optional.empty();
        }
        return Optional.of(new ProjectConfig(pConfigAo[0].getProjectKey(), pConfigAo[0].getServerUuid(), pConfigAo[0].isActivated(), pConfigAo[0].getTestCasesTabName(), pConfigAo[0].getExecutionsTabName()));
    }

    @Override
    public ProjectConfig saveSquashProjectConfig(ProjectConfig config) {
        ProjectConfigActiveObject pConfigAo = (ProjectConfigActiveObject)this.ao.create(ProjectConfigActiveObject.class, new DBParam[0]);
        pConfigAo.setProjectKey(config.getProjectKey());
        pConfigAo.setServerUuid(config.getServerUuid());
        pConfigAo.setActivated(config.isActivated());
        pConfigAo.setTestCasesTabName(config.getTestCasesTabName());
        pConfigAo.setExecutionsTabName(config.getExecutionsTabName());
        pConfigAo.save();
        return new ProjectConfig(pConfigAo.getProjectKey(), pConfigAo.getServerUuid(), pConfigAo.isActivated(), pConfigAo.getTestCasesTabName(), pConfigAo.getExecutionsTabName());
    }

    @Override
    public ProjectConfig updateSquashProjectConfig(ProjectConfig config) {
        ProjectConfigActiveObject[] pConfigAo = (ProjectConfigActiveObject[])this.ao.find(ProjectConfigActiveObject.class, Query.select().where("PROJECT_KEY = ?", new Object[]{config.getProjectKey()}));
        pConfigAo[0].setProjectKey(config.getProjectKey());
        pConfigAo[0].setServerUuid(config.getServerUuid());
        pConfigAo[0].setActivated(config.isActivated());
        pConfigAo[0].setTestCasesTabName(config.getTestCasesTabName());
        pConfigAo[0].setExecutionsTabName(config.getExecutionsTabName());
        pConfigAo[0].save();
        return new ProjectConfig(pConfigAo[0].getProjectKey(), pConfigAo[0].getServerUuid(), pConfigAo[0].isActivated(), pConfigAo[0].getTestCasesTabName(), pConfigAo[0].getExecutionsTabName());
    }

    @Override
    public void deleteSquashProjectConfig(String pKey) {
        this.ao.deleteWithSQL(SquashServerConfigActiveObject.class, "PROJECT_KEY = ?", new Object[]{pKey});
    }

    @Override
    public Boolean isProjectConfigIsAlreadySet(String pKey) {
        ProjectConfigActiveObject[] pConfigAo = (ProjectConfigActiveObject[])this.ao.find(ProjectConfigActiveObject.class, Query.select().where("PROJECT_KEY = ?", new Object[]{pKey}));
        return pConfigAo.length > 0;
    }
}

