/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.plugin.jira.Xsquash.service.impl;

import com.atlassian.jira.util.UrlBuilder;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.log4j.Logger;
import org.squashtest.plugin.jira.Xsquash.domain.model.jira.SquashServerConfig;
import org.squashtest.plugin.jira.Xsquash.domain.model.squash.SquashAttachmentModel;
import org.squashtest.plugin.jira.Xsquash.service.SquashAttachmentManagementService;
import org.squashtest.plugin.jira.Xsquash.util.SquashRestApiRequestUtil;

@Named
public class SquashAttachmentManagementServiceImpl
implements SquashAttachmentManagementService {
    private static final Logger log = Logger.getLogger(SquashAttachmentManagementServiceImpl.class);
    private static final String SQUASH_API_ATTACHMENTS_PATH = "/api/rest/latest/attachments/%s/content";

    @Override
    public String replaceAttachmentWithBase64(SquashAttachmentModel attachment, SquashServerConfig squashServerConfig, String fieldToUpdate) {
        Long attachmentId = attachment.getId();
        Optional<SquashRestApiRequestUtil.ImageData> file = this.downloadSquashAttachment(attachmentId, squashServerConfig);
        if (file.isEmpty()) {
            log.warn((Object)("Attachment with ID " + attachmentId + " not found in SquashTM."));
            return fieldToUpdate;
        }
        return file.map(extractedFile -> this.updateSrcAttribute(fieldToUpdate, attachmentId, extractedFile.getBase64(), extractedFile.getMimeType())).orElse("");
    }

    private String updateSrcAttribute(String action, Long attachmentId, String base64Image, String mimeType) {
        Pattern SRC_PATTERN = Pattern.compile("src=\"([^\"]+)\"");
        Matcher matcher = SRC_PATTERN.matcher(action);
        StringBuilder updatedAction = new StringBuilder();
        int lastEnd = 0;
        while (matcher.find()) {
            String srcContent = matcher.group(1);
            if (!srcContent.endsWith("/" + attachmentId)) continue;
            updatedAction.append(action, lastEnd, matcher.start());
            updatedAction.append("src=\"data:").append(mimeType).append(";base64,").append(base64Image).append("\"");
            lastEnd = matcher.end();
        }
        updatedAction.append(action.substring(lastEnd));
        return updatedAction.toString();
    }

    private Optional<SquashRestApiRequestUtil.ImageData> downloadSquashAttachment(Long attachmentId, SquashServerConfig squashServerConfig) {
        String requestURL = String.format(squashServerConfig.getSquashURL() + SQUASH_API_ATTACHMENTS_PATH, attachmentId);
        UrlBuilder urlBuilder = new UrlBuilder(requestURL);
        HttpClientContext context = SquashRestApiRequestUtil.createHttpClientContext(urlBuilder.asURI(), squashServerConfig);
        return SquashRestApiRequestUtil.downloadImageAsBase64(urlBuilder.asURI(), squashServerConfig, context);
    }
}

