/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.plugin.jira.Xsquash.service.impl;

import com.atlassian.jira.util.UrlBuilder;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.http.client.protocol.HttpClientContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.plugin.jira.Xsquash.domain.model.jira.SquashServerConfig;
import org.squashtest.plugin.jira.Xsquash.service.LicenseService;
import org.squashtest.plugin.jira.Xsquash.service.SquashServerConfigService;
import org.squashtest.plugin.jira.Xsquash.util.SquashRestApiRequestUtil;

@Named(value="LicenseService")
public class LicenseServiceImpl
implements LicenseService {
    private static final Logger log = LoggerFactory.getLogger(LicenseServiceImpl.class);
    private static final String SQUASH_API_LICENSE_INFO_PATH = "/api/rest/latest/xsquash/is-valid-license";
    @Inject
    private SquashServerConfigService sqService;
    private static final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public boolean isValidLicenseForXsquash(String projectKey) {
        Boolean isValidLicenseForXsquash;
        String jsonResponse;
        SquashServerConfig squashServerConfig = this.sqService.getSquashServerConfigByJiraProjectKey(projectKey);
        if (squashServerConfig == null) {
            log.error("SquashServerConfig is null for projectKey: {}", (Object)projectKey);
            return false;
        }
        String requestUrl = squashServerConfig.getSquashURL() + SQUASH_API_LICENSE_INFO_PATH;
        log.debug("requestUrl : {}", (Object)requestUrl);
        UrlBuilder urlBuilder = new UrlBuilder(requestUrl);
        HttpClientContext context = SquashRestApiRequestUtil.createHttpClientContext(urlBuilder.asURI(), squashServerConfig);
        try {
            jsonResponse = SquashRestApiRequestUtil.makeRestCallToSquash(urlBuilder.asURI(), context, squashServerConfig);
            log.debug("jsonResponse : {}", (Object)jsonResponse);
        }
        catch (Exception e) {
            log.error("Error making REST call to SquashTM", (Throwable)e);
            return false;
        }
        try {
            isValidLicenseForXsquash = (Boolean)objectMapper.readValue(jsonResponse, Boolean.class);
        }
        catch (IOException e) {
            log.error("Deserialization error", (Throwable)e);
            return false;
        }
        log.debug("isValidLicenseForXsquash : {}", (Object)isValidLicenseForXsquash);
        return Boolean.TRUE.equals(isValidLicenseForXsquash);
    }
}

