/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.plugin.jira.Xsquash.service.impl;

import com.atlassian.jira.issue.Issue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.squashtest.plugin.jira.Xsquash.domain.dao.IterationTestPlanItemDao;
import org.squashtest.plugin.jira.Xsquash.domain.model.jira.SquashServerConfig;
import org.squashtest.plugin.jira.Xsquash.domain.model.squash.SquashAttachmentModel;
import org.squashtest.plugin.jira.Xsquash.domain.model.squash.SquashCampaignStub;
import org.squashtest.plugin.jira.Xsquash.domain.model.squash.SquashExecutionModel;
import org.squashtest.plugin.jira.Xsquash.domain.model.squash.SquashIterationModel;
import org.squashtest.plugin.jira.Xsquash.domain.model.squash.SquashIterationTestPlanItemModel;
import org.squashtest.plugin.jira.Xsquash.domain.model.squash.SquashIterationTestPlanItemStub;
import org.squashtest.plugin.jira.Xsquash.service.IterationTestPlanItemFinder;
import org.squashtest.plugin.jira.Xsquash.service.SquashAttachmentManagementService;
import org.squashtest.plugin.jira.Xsquash.service.SquashServerConfigService;
import org.squashtest.plugin.jira.Xsquash.web.tabpanels.SquashExecutionStatus;

@Named
public class IterationTestPlanItemFinderImpl
implements IterationTestPlanItemFinder {
    private static final Logger log = Logger.getLogger(IterationTestPlanItemFinderImpl.class);
    private static final String ERROR_MESSAGE_JSON_PARSING = "JSON parsing exception ";
    private static final String ERROR_MESSAGE_JSON_MAPPING = "JSON mapping exception ";
    private static final String ERROR_MESSAGE_IO = "IO exception ";
    private static final String ERROR_MESSAGE_ACCESS_DENIED_ITPI_SEARCH = "An exception occurred during SquashTM itpi search";
    private static final String ERROR_MESSAGE_ITPI_STUB_CONTEXT = "during SquashTM itpi list search";
    private static final String ERROR_MESSAGE_ITPI_SEARCH_CONTEXT = "during SquashTM itpi search";
    private static final String URL_EXTENDER_TEST_CASE = "/test-case-workspace/test-case/%s";
    private static final String URL_EXTENDER_EXECUTION = "/execution/%s";
    private static final String URL_EXTENDER_SESSION = "/session-overview/%d";
    private static final String URL_EXTENDER_ITERATION = "/campaign-workspace/iteration/%s";
    private static final String URL_EXTENDER_CAMPAIGN = "/campaign-workspace/campaign/%s";
    private static final String JSON_EMBEDDED_NODE = "_embedded";
    private static final String JSON_ITPI_NODE = "iteration-test-plan-items";
    private static final String JSON_PAGE_NODE = "page";
    private static final String JSON_TOTAL_PAGES_NODE = "totalPages";
    private static ObjectMapper objectMapper = new ObjectMapper();
    private static Map<String, Integer> executionStatusValueMap = new HashMap<String, Integer>();
    private static Comparator<SquashIterationTestPlanItemModel> squashIterationTestPlanItemModelComparator;
    @Inject
    private SquashServerConfigService sqService;
    @Inject
    private IterationTestPlanItemDao iterationTestPlanItemDao;
    @Inject
    private SquashAttachmentManagementService squashAttachmentManagementService;

    @Override
    public List<SquashIterationTestPlanItemModel> getIterationTestPlanItemFromSquash(Issue issue) {
        ArrayList<SquashIterationTestPlanItemModel> result = new ArrayList<SquashIterationTestPlanItemModel>();
        List<SquashIterationTestPlanItemStub> stubList = this.findIterationTestPlanItemList(issue);
        stubList.forEach(squashIterationTestPlanItemStub -> {
            SquashIterationTestPlanItemModel model = this.findSquashTMIterationTestPlanItem((SquashIterationTestPlanItemStub)squashIterationTestPlanItemStub, issue.getProjectObject().getKey());
            if (model != null) {
                result.add(model);
            }
        });
        result.forEach(squashIterationTestPlanItemModel -> this.handleAttachments((SquashIterationTestPlanItemModel)squashIterationTestPlanItemModel, issue.getProjectObject().getKey()));
        result.sort(squashIterationTestPlanItemModelComparator);
        return result;
    }

    @Override
    public long findIterationTestPlanItemsNumber(Issue issue) {
        List<SquashIterationTestPlanItemStub> stubList = this.findIterationTestPlanItemList(issue);
        return stubList.size();
    }

    private SquashIterationTestPlanItemModel findSquashTMIterationTestPlanItem(SquashIterationTestPlanItemStub squashIterationTestPlanItemStub, String projectKey) {
        SquashIterationTestPlanItemModel model;
        SquashServerConfig squashServerConfig = this.sqService.getSquashServerConfigByJiraProjectKey(projectKey);
        String result = this.iterationTestPlanItemDao.findSquashTMIterationTestPlanItemByIdAsJson(squashIterationTestPlanItemStub, squashServerConfig);
        if (Objects.isNull(result) || result.contains("org.springframework.security.access.AccessDeniedException")) {
            log.debug((Object)ERROR_MESSAGE_ACCESS_DENIED_ITPI_SEARCH);
            model = null;
        } else {
            try {
                model = (SquashIterationTestPlanItemModel)objectMapper.readValue(result, SquashIterationTestPlanItemModel.class);
                model.getReferencedTestCase().setSquashURL(String.format(squashServerConfig.getSquashURL() + URL_EXTENDER_TEST_CASE, model.getReferencedTestCase().getId()));
                SquashIterationModel iteration = model.getIteration();
                iteration.setSquashURL(String.format(squashServerConfig.getSquashURL() + URL_EXTENDER_ITERATION, iteration.getId()));
                SquashCampaignStub campaign = iteration.getCampaign();
                campaign.setSquashURL(String.format(squashServerConfig.getSquashURL() + URL_EXTENDER_CAMPAIGN, campaign.getId()));
                List<SquashExecutionModel> executionList = model.getExecutions();
                if (!executionList.isEmpty()) {
                    executionList.sort(Comparator.comparing(SquashExecutionModel::getLastExecutionDate, Comparator.nullsFirst(Comparator.naturalOrder())));
                    SquashExecutionModel lastExecution = IterationTestPlanItemFinderImpl.getLastExecution(executionList, model, squashServerConfig);
                    model.setLastExecution(lastExecution);
                }
            }
            catch (JsonParseException e) {
                log.error((Object)"JSON parsing exception during SquashTM itpi search", (Throwable)e);
                throw new RuntimeException("JSON parsing exception during SquashTM itpi search", e);
            }
            catch (JsonMappingException e) {
                log.error((Object)"JSON mapping exception during SquashTM itpi search", (Throwable)e);
                throw new RuntimeException("JSON mapping exception during SquashTM itpi search", e);
            }
            catch (IOException e) {
                log.error((Object)"IO exception during SquashTM itpi search", (Throwable)e);
                throw new RuntimeException("IO exception during SquashTM itpi search", e);
            }
        }
        return model;
    }

    private static SquashExecutionModel getLastExecution(List<SquashExecutionModel> executionList, SquashIterationTestPlanItemModel model, SquashServerConfig squashServerConfig) {
        SquashExecutionModel lastExecution = executionList.get(executionList.size() - 1);
        if (model.getExploratorySessionOverview() != null) {
            Long sessionId = model.getExploratorySessionOverview().getId();
            lastExecution.setSquashURL(String.format(squashServerConfig.getSquashURL() + URL_EXTENDER_SESSION, sessionId));
        } else {
            lastExecution.setSquashURL(String.format(squashServerConfig.getSquashURL() + URL_EXTENDER_EXECUTION, lastExecution.getId()));
        }
        return lastExecution;
    }

    private List<SquashIterationTestPlanItemStub> findIterationTestPlanItemList(Issue issue) {
        List<SquashIterationTestPlanItemStub> stubList = new ArrayList<SquashIterationTestPlanItemStub>();
        int totalPages = 0;
        int currentPageNumber = 0;
        do {
            String jsonResponse = this.iterationTestPlanItemDao.findSquashTMIterationTestPlanItemsListByJiraIssueAsJson(issue, Integer.toString(currentPageNumber));
            try {
                JsonNode json = objectMapper.readTree(jsonResponse);
                JsonNode embeddedNode = json.get(JSON_EMBEDDED_NODE);
                if (embeddedNode == null) continue;
                JsonNode pageNode = json.get(JSON_PAGE_NODE);
                totalPages = pageNode.get(JSON_TOTAL_PAGES_NODE).asInt();
                JsonNode iterationTestPlanItemsNode = embeddedNode.get(JSON_ITPI_NODE);
                stubList = (List)objectMapper.convertValue((Object)iterationTestPlanItemsNode, (TypeReference)new TypeReference<List<SquashIterationTestPlanItemStub>>(){});
            }
            catch (JsonParseException e) {
                log.error((Object)"JSON parsing exception during SquashTM itpi list search", (Throwable)e);
                throw new RuntimeException("JSON parsing exception during SquashTM itpi list search", e);
            }
            catch (JsonMappingException e) {
                log.error((Object)"JSON mapping exception during SquashTM itpi list search", (Throwable)e);
                throw new RuntimeException("JSON mapping exception during SquashTM itpi list search", e);
            }
            catch (IOException e) {
                log.error((Object)"IO exception during SquashTM itpi list search", (Throwable)e);
                throw new RuntimeException("IO exception during SquashTM itpi list search", e);
            }
        } while (++currentPageNumber < totalPages && currentPageNumber != totalPages - 1);
        return stubList;
    }

    private void handleAttachments(SquashIterationTestPlanItemModel itpiModel, String projectKey) {
        SquashServerConfig squashServerConfig = this.sqService.getSquashServerConfigByJiraProjectKey(projectKey);
        itpiModel.getExecutions().forEach(execution -> {
            this.processAttachments(execution.getAttachments(), squashServerConfig, execution::getComment, execution::setComment);
            execution.getExecutionSteps().forEach(step -> this.processAttachments(step.getAttachments(), squashServerConfig, step::getComment, step::setComment));
            if (execution.getSessionNotes() != null) {
                execution.getSessionNotes().forEach(sessionNote -> this.processAttachments(sessionNote.getAttachments(), squashServerConfig, sessionNote::getContent, sessionNote::setContent));
            }
        });
        if (itpiModel.getExploratorySessionOverview() != null) {
            this.processAttachments(itpiModel.getExploratorySessionOverview().getAttachments(), squashServerConfig, itpiModel.getExploratorySessionOverview()::getComments, itpiModel.getExploratorySessionOverview()::setComments);
        }
    }

    private void processAttachments(List<SquashAttachmentModel> attachments, SquashServerConfig squashServerConfig, Supplier<String> getter, Consumer<String> setter) {
        if (attachments != null && !attachments.isEmpty() && getter.get() != null) {
            String updatedContent = attachments.stream().reduce(getter.get(), (content, attachment) -> this.squashAttachmentManagementService.replaceAttachmentWithBase64((SquashAttachmentModel)attachment, squashServerConfig, (String)content), (c1, c2) -> c2);
            setter.accept(updatedContent);
        }
    }

    private static void configureObjectMapper() {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    private static void initExecutionStatusMap() {
        for (SquashExecutionStatus status : SquashExecutionStatus.values()) {
            executionStatusValueMap.put(status.name(), status.getValue());
        }
    }

    private static void createComparator() {
        squashIterationTestPlanItemModelComparator = Comparator.comparing(SquashIterationTestPlanItemModel::getId).reversed();
    }

    static {
        IterationTestPlanItemFinderImpl.initExecutionStatusMap();
        IterationTestPlanItemFinderImpl.createComparator();
        IterationTestPlanItemFinderImpl.configureObjectMapper();
    }
}

