/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.plugin.jira.Xsquash.service.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Named;
import org.squashtest.plugin.jira.Xsquash.domain.model.squash.SquashAttachmentModel;
import org.squashtest.plugin.jira.Xsquash.domain.model.squash.SquashTestStepModel;

@Named
public class SquashTestStepDeserializer
extends JsonDeserializer<SquashTestStepModel> {
    private static final String TEST_CASE_JSON_ID_FIELD = "id";
    private static final String TEST_CASE_JSON_NAME_FIELD = "name";
    private static final String TEST_CASE_JSON_SUB_TYPE_FIELD = "_type";
    private static final String TEST_CASE_JSON_ACTION_STEP_FIELD = "action-step";
    private static final String TEST_CASE_JSON_ACTION_STEP_ACTION_FIELD = "action";
    private static final String TEST_CASE_JSON_ACTION_STEP_ATTACHMENT_FIELD = "attachments";
    private static final String TEST_CASE_JSON_ACTION_STEP_ATTACHMENT_FIELD_ID = "id";
    private static final String TEST_CASE_JSON_ACTION_STEP_ATTACHMENT_FIELD_HREF = "href";
    private static final String TEST_CASE_JSON_ACTION_STEP_ATTACHMENT_FIELD_LINKS = "_links";
    private static final String TEST_CASE_JSON_ACTION_STEP_ATTACHMENT_FIELD_SELF = "self";
    private static final String TEST_CASE_JSON_ACTION_STEP_EXPECTED_RESULT_FIELD = "expected_result";
    private static final String TEST_CASE_JSON_CALL_STEP_FIELD = "call-step";
    private static final String TEST_CASE_JSON_CALL_STEP_CALL_TEST_CASE_FIELD = "called_test_case";
    private static final String TEST_CASE_JSON_CALL_STEP_CALL_DATASET_FIELD = "called_dataset";
    private static final String TEST_CASE_JSON_CALL_STEP_DELEGATE_PARAMETER_FIELD = "delegate_parameter_values";
    private static final String TEST_CASE_JSON_RESOURCE_ID_FIELD = "resource_id";
    private static final String TEST_CASE_JSON_TEST_CASE_FIELD = "test-case";
    private static final String TEST_CASE_JSON_KEYWORD_STEP_FIELD = "keyword-step";
    private static final String TEST_CASE_JSON_KEYWORD_STEP_KEYWORD_FIELD = "keyword";
    private static final String TEST_CASE_JSON_KEYWORD_STEP_ACTION_FIELD = "action";
    private static final String TEST_CASE_JSON_KEYWORD_STEP_DATATABLE_FIELD = "datatable";
    private static final String TEST_CASE_JSON_KEYWORD_STEP_DOCSTRING_FIELD = "docstring";
    private static final String TEST_CASE_JSON_KEYWORD_STEP_COMMENT_FIELD = "comment";
    private static final String KEYWORD_DOCSTRING_MARKER = "\"\"\"";
    private static final String KEYWORD_COMMENT_MARKER = "#";

    public SquashTestStepModel deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode testStepNode = (JsonNode)jsonParser.readValueAsTree();
        SquashTestStepModel testStep = new SquashTestStepModel();
        testStep.setId(testStepNode.get("id").asLong());
        switch (testStepNode.get(TEST_CASE_JSON_SUB_TYPE_FIELD).asText()) {
            case "action-step": {
                testStep.setAction(testStepNode.get("action").asText());
                testStep.setResult(testStepNode.get(TEST_CASE_JSON_ACTION_STEP_EXPECTED_RESULT_FIELD).asText());
                JsonNode attachmentsNode = testStepNode.path(TEST_CASE_JSON_ACTION_STEP_ATTACHMENT_FIELD);
                List<SquashAttachmentModel> attachments = StreamSupport.stream(attachmentsNode.spliterator(), false).map(this::extractAttachment).collect(Collectors.toList());
                testStep.setAttachments(attachments);
                break;
            }
            case "call-step": {
                testStep.setCallStep(true);
                JsonNode calledTestCaseNode = testStepNode.get(TEST_CASE_JSON_CALL_STEP_CALL_TEST_CASE_FIELD);
                if (calledTestCaseNode.get(TEST_CASE_JSON_SUB_TYPE_FIELD).asText().equals(TEST_CASE_JSON_TEST_CASE_FIELD)) {
                    testStep.setCalledTestCase(true);
                    testStep.setCalledTestCaseName(calledTestCaseNode.get(TEST_CASE_JSON_NAME_FIELD).asText());
                } else {
                    testStep.setCalledResourceId(calledTestCaseNode.get(TEST_CASE_JSON_RESOURCE_ID_FIELD).asLong());
                }
                testStep.setHasDelegatedParameters(testStepNode.get(TEST_CASE_JSON_CALL_STEP_DELEGATE_PARAMETER_FIELD).asBoolean());
                JsonNode calledDatasetNode = testStepNode.get(TEST_CASE_JSON_CALL_STEP_CALL_DATASET_FIELD);
                if (calledDatasetNode.isNull()) break;
                testStep.setCalledDataSetName(calledDatasetNode.get(TEST_CASE_JSON_NAME_FIELD).asText());
                break;
            }
            case "keyword-step": {
                JsonNode commentNode;
                JsonNode docstringNode;
                StringBuilder builder = new StringBuilder();
                String keyword = testStepNode.get(TEST_CASE_JSON_KEYWORD_STEP_KEYWORD_FIELD).asText();
                builder.append(keyword).append(" ");
                String action = testStepNode.get("action").asText().replaceAll("<", "&lt;").replaceAll(">", "&gt;");
                builder.append(action);
                JsonNode datatableNode = testStepNode.get(TEST_CASE_JSON_KEYWORD_STEP_DATATABLE_FIELD);
                if (!datatableNode.isNull() && !datatableNode.asText().isEmpty()) {
                    builder.append("<br/>").append(datatableNode.asText().replaceAll("\n", "<br/>"));
                }
                if (!(docstringNode = testStepNode.get(TEST_CASE_JSON_KEYWORD_STEP_DOCSTRING_FIELD)).isNull() && !docstringNode.asText().isEmpty()) {
                    builder.append("<br/>").append(KEYWORD_DOCSTRING_MARKER).append("<br/>").append(docstringNode.asText().replaceAll("\n", "<br/>")).append("<br/>").append(KEYWORD_DOCSTRING_MARKER);
                }
                if (!(commentNode = testStepNode.get(TEST_CASE_JSON_KEYWORD_STEP_COMMENT_FIELD)).isNull() && !commentNode.asText().isEmpty()) {
                    builder.append("<br/>").append(KEYWORD_COMMENT_MARKER).append(commentNode.asText().replaceAll("\n", "<br/>#"));
                }
                testStep.setAction(builder.toString());
            }
        }
        return testStep;
    }

    private SquashAttachmentModel extractAttachment(JsonNode attachmentNode) {
        JsonNode hrefNode = attachmentNode.path(TEST_CASE_JSON_ACTION_STEP_ATTACHMENT_FIELD_LINKS).path(TEST_CASE_JSON_ACTION_STEP_ATTACHMENT_FIELD_SELF).path(TEST_CASE_JSON_ACTION_STEP_ATTACHMENT_FIELD_HREF);
        long attachmentId = attachmentNode.path("id").asLong();
        return new SquashAttachmentModel(attachmentId, hrefNode.asText());
    }
}

