/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.plugin.jira.Xsquash.service.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.squashtest.plugin.jira.Xsquash.domain.model.squash.SquashAttachmentModel;

public class SquashAttachmentDeserializer
extends JsonDeserializer<SquashAttachmentModel> {
    private static final String ATTACHMENT_FIELD_ID = "id";
    private static final String ATTACHMENT_FIELD_HREF = "href";
    private static final String ATTACHMENT_FIELD_LINKS = "_links";
    private static final String ATTACHMENT_FIELD_SELF = "self";

    public SquashAttachmentModel deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        JsonNode selfNode;
        JsonNode attachmentNode = (JsonNode)jsonParser.readValueAsTree();
        SquashAttachmentModel attachment = new SquashAttachmentModel();
        attachment.setId(attachmentNode.get(ATTACHMENT_FIELD_ID).asLong());
        JsonNode linksNode = attachmentNode.get(ATTACHMENT_FIELD_LINKS);
        if (linksNode != null && linksNode.has(ATTACHMENT_FIELD_SELF) && (selfNode = linksNode.get(ATTACHMENT_FIELD_SELF)).has(ATTACHMENT_FIELD_HREF)) {
            attachment.setHref(selfNode.get(ATTACHMENT_FIELD_HREF).asText());
        }
        return attachment;
    }
}

