/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.plugin.jira.Xsquash.service.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class LocalDateTimeDeserializer
extends JsonDeserializer<Date> {
    private static final Logger log = Logger.getLogger(LocalDateTimeDeserializer.class);
    private static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";

    public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        String date = jsonParser.getText();
        Date result = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_PATTERN);
        try {
            result = sdf.parse(date);
        }
        catch (ParseException e) {
            log.error((Object)e);
        }
        return result;
    }
}

