/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.plugin.jira.Xsquash.listener;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.List;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;
import org.squashtest.plugin.jira.Xsquash.domain.dao.JiraConfigDao;
import org.squashtest.plugin.jira.Xsquash.domain.model.jira.GlobalConfig;
import org.squashtest.plugin.jira.Xsquash.domain.model.jira.ProjectConfig;
import org.squashtest.plugin.jira.Xsquash.domain.model.jira.SquashServerConfig;
import org.squashtest.plugin.jira.Xsquash.service.SquashProjectConfigService;
import org.squashtest.plugin.jira.Xsquash.service.SquashServerConfigService;

@Component
public class PluginInstallationListener
implements InitializingBean,
DisposableBean {
    private static final Logger log = Logger.getLogger(PluginInstallationListener.class);
    private final EventPublisher eventPublisher;
    private final JiraConfigDao jiraConfigDao;
    private final SquashServerConfigService sqService;
    private final SquashProjectConfigService pcService;
    private final PluginSettingsFactory pluginSettingsFactory;
    private static final String PLUGIN_KEY = "org.squashtest.plugin.jira.Xsquash";
    private static final String XSQUASH_GLOBAL_CONFIG_KEY = "xsquash-global-configuration";
    private static final String XSQUASH_PROJECT_CONFIG_KEY = "xsquash-project-configuration";

    @Inject
    public PluginInstallationListener(@ComponentImport EventPublisher eventPublisher, JiraConfigDao jiraConfigDao, SquashServerConfigService sqService, SquashProjectConfigService pcService, PluginSettingsFactory pluginSettingsFactory) {
        this.eventPublisher = eventPublisher;
        this.jiraConfigDao = jiraConfigDao;
        this.sqService = sqService;
        this.pcService = pcService;
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onPluginStarted(PluginEnabledEvent pluginEnabledEvent) {
        String startUpPluginKey = pluginEnabledEvent.getPlugin().getKey();
        if (PLUGIN_KEY.equals(startUpPluginKey)) {
            this.migrateXsquashConfigFromPluginsSettingsToActiveObject();
            this.deleteXsquashPluginSettingConfiguration();
        }
    }

    private void migrateXsquashConfigFromPluginsSettingsToActiveObject() {
        List<SquashServerConfig> oldSystemSquahServerConfigList = this.getSquashServerConfigList();
        for (SquashServerConfig serverConfig : oldSystemSquahServerConfigList) {
            List<ProjectConfig> oldSystemProjectConfigList = this.jiraConfigDao.getAllProjectConfig(serverConfig.getId());
            SquashServerConfig savedSquashServerConfig = this.sqService.saveSquashServerConfig(serverConfig, false);
            for (ProjectConfig projectConfig : oldSystemProjectConfigList) {
                projectConfig.setServerUuid(savedSquashServerConfig.getId());
                this.pcService.saveSquashProjectConfig(projectConfig);
            }
        }
    }

    private void deleteXsquashPluginSettingConfiguration() {
        PluginSettings globalSettings = this.pluginSettingsFactory.createGlobalSettings();
        globalSettings.remove(XSQUASH_GLOBAL_CONFIG_KEY);
        globalSettings.remove(XSQUASH_PROJECT_CONFIG_KEY);
    }

    private List<SquashServerConfig> getSquashServerConfigList() {
        GlobalConfig globalConfig = this.jiraConfigDao.getGlobalConfig();
        return globalConfig.getSquashServerConfigListOrderedByName();
    }
}

